/*!
	IResponse

	X|Xׂ̎C^tF[X
*/

#pragma once
#include "InterfaceTemplate.h"
#include "Context.h"
#include "IServerTool.h"
#include "IConnectionControl.h"
#include "IConnectionThreadStatus.h"

//!	C^[tF[X`
class IResponse;
class IResponseFactory;
class IResponseContext;
DEFINE_INTERFACE(IResponse);
DEFINE_INTERFACE(IResponseFactory);
DEFINE_INTERFACE_NOWRAP(IResponseContext);

/*!
	X|XReLXg
*/
class IResponseContext
{
public:
	virtual ~IResponseContext() {};

	//!	C^tF[X擾
	virtual IResponseContextPtr GetIResponseContext() = 0;

	//!	T[oc[擾
	virtual IServerToolPtr GetIServerTool() = 0;

	//!	XbhXe[^X擾
	virtual IConnectionThreadStatusPtr GetIConnectionThreadStatus() = 0;

	//!	ڑ擾
	virtual IConnectionControlPtr GetIConnectionControl() = 0;
		
	//!	ReLXg擾
	virtual CContext GetContxet() = 0;
};



/*!
	X|XNX
*/
class IResponseFactory
{
public:
	virtual ~IResponseFactory(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void StartFactory(IServerToolPtr serverTool) = 0;

	//!	~
	virtual void StopFactory() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int IsYourRequest(CContext context) = 0;

	//!	X|X擾
	virtual IResponsePtr GetResponse() = 0;
};


/*!
	X|XNX
*/
class IResponse
{
public:
	virtual ~IResponse(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void Start(IResponseContextPtr responseContext) = 0;

	//!	~(OցI)
	virtual void Stop(IResponseContextPtr responseContext) = 0;

	//!	X|X擾(Kstatic̈ɐ錾Ȃ΂ȂȂ)
	virtual LPCTSTR GetResponseName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void SetRequest(IResponseContextPtr responseContext, CContextRequestInfo requestInfo) = 0;

	//!	NGXg{fBݒ(JԂ)
	virtual void SetRequestBody(IResponseContextPtr responseContext, CBinaryData &body) = 0;

	//!	NGXg
	virtual void EndRequest(IResponseContextPtr responseContext) = 0;


	//!	X|X
	virtual void BuildResponse(IResponseContextPtr responseContext) = 0;


	//!	X|Xwb_擾
	virtual void GetResponse(IResponseContextPtr responseContext, CContextResponseInfo responseInfo) = 0;

	//!	X|X{fB擾
	virtual int GetResponseBody(IResponseContextPtr responseContext, CBinaryData &body, int blockSize) = 0;

	//!	X|X
	virtual void EndResponse(IResponseContextPtr responseContext) = 0;
};

