#include "StdAfx.h"
#include "PathManager.h"
#include "ServerException.h"
#include "ServerStartErrorException.h"
#include "TextTools.h"

#define	CLASS_NAME	"PathManager"

CPathManager::CPathManager(void)
{
}

CPathManager::~CPathManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CPathManager::Start(IServerToolPtr serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	擾
	m_serverTool = serverTool;
	m_pathSetting = m_serverTool->GetManagerSetting(m_pathSetting.GetSettingName());
	m_pathList = m_pathSetting.GetPathList();

	//	pXݒ萔擾
	if(m_pathList.GetItemCount() <= 0)
		throw CServerStartErrorException(CLASS_NAME, "pXݒ肪ЂƂ݂܂");

	//	CfbNX쐬
	m_pathIndex.SetSize(m_pathList.GetItemCount());
	m_pathIndexLen.SetSize(m_pathList.GetItemCount());
	m_hostIndex.SetSize(m_pathList.GetItemCount());
	for(int i=0;i<m_pathList.GetItemCount();i++)
	{
		m_pathIndex[i] = m_pathList.GetItem(i).GetServerPath().MakeUpper();
		m_pathIndexLen[i] = m_pathIndex[i].GetLength();
		m_hostIndex[i] = m_pathList.GetItem(i).GetVirtualHost().MakeUpper();
	}


	m_enableVirtualHost = TRUE;
}

/*!
	~
*/
void CPathManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////
//	C^[tF[X
///////////////////////////////////////////////////////////////////////////////////////////
/*!
	pX

	\return FALSE:Ȃ
*/
int CPathManager::FindPath(CString path, CString host, CPathInfo pathInfo)
{
	SCOPE_LOCK();

	//	
	path = path.MakeUpper();
	int	pathLen = path.GetLength();
	host = host.MakeUpper();

	//	
	int	maxLen = 0, maxIndex = -1;
	for(int i=0;i<m_pathIndexLen.GetCount();i++)
	{
		//	
		if(m_pathIndexLen[i] > maxLen && m_pathIndexLen[i] <= pathLen)
		{
			//	pX
			if(path.Left(m_pathIndexLen[i]) == m_pathIndex[i])
			{
				//	zXg
				if(!m_enableVirtualHost || m_hostIndex[i].IsEmpty() || CTextTools::WildCompare(m_hostIndex[i], host))
				{
					maxLen = m_pathIndexLen[i];
					maxIndex = i;
				}
			}
		}
	}

	if(maxIndex == -1)
		return(FALSE);

	pathInfo.Copy(m_pathList.GetItem(maxIndex));
	return(TRUE);
}

/*!
	pX擾
*/
int CPathManager::GetPathCount()
{
	SCOPE_LOCK();

	return(m_pathIndexLen.GetCount());
}

/*!
	CfbNXpX擾
*/
int CPathManager::GetPathByIndex(int index, CPathInfo pathInfo)
{
	SCOPE_LOCK();

	if(index < 0 || index > m_pathIndexLen.GetCount())
		return(-1);

	pathInfo.Copy(m_pathList.GetItem(index));
	return(0);
}

