#include "StdAfx.h"
#include "ServerStatusManager.h"
#include "Dir.h"
#include "TextTools.h"
#include "DateUtility.h"

#define	CLASS_NAME			"StatusManager"


CServerStatusManager::CServerStatusManager(void)
{
	m_serverStatus = m_statusRoot.GetAccess("Status");
}

CServerStatusManager::~CServerStatusManager(void)
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CServerStatusManager::Start(IServerToolPtr serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	{̐ݒ
	m_serverStatus.SetServerVersion(SERVER_VERSION);
	m_serverStatus.SetServerVersionString(SERVER_VERSION_STRING);
	m_serverStatus.SetServerRoot(CPathTools::GetAppPath());

	//	VXeO
	m_systemLog.Start(serverTool->GetIServerTool());
}

/*!
	~
*/
void CServerStatusManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;

	//	~
	m_systemLog.Stop();

	m_init = FALSE;
}

/*!
	T[oXe[^X̕ύX
*/
void CServerStatusManager::WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Ŝ
	statusInfo.Replace("\r", "_");
	statusInfo.Replace("\n", "_");

	//	ŐVACe擾
	CServerStatusLog log = m_serverStatus.GetStatusLog(callerName).GetNewItem();
	log.SetStatusCode(statusCode);
	log.SetStatusInfo(statusInfo);
	log.SetTime(CDateUtility::GetTimeString(CTime::GetCurrentTime()));
	log.SetAutoOffTime(autoOffTime);

	TRACE("<%s> %s\n", callerName, statusInfo);

	//	KvȂ烍O
	if(statusCode <= SERVER_STATUS_NORMAL_LOG)
		m_systemLog.WriteSystemLog(callerName, statusInfo);
};



