/*
	\file	CWorkspace.h
	\brief	KwϐǗNX

	2006/04/05	XMLۑ`̕ύX
	2006/11/14	XMLo͕@ύX
*/

#pragma once

#include ".\workspacenode.h"
#include ".\workspaceaccess.h"
#include "InterfaceTemplate.h"
#include "FilterAPIWorkspace.h"

/*!
	u
*/
class IWorkspaceAutoSwap
{
public:
	virtual ~IWorkspaceAutoSwap() {};

	//!	ʏ̎擾
	virtual CString GetKeyDataSwap(IWorkspace *workspace, const LPCSTR orgKey, CString orgData) = 0;
};
//	C^[tF[X`
DEFINE_INTERFACE(IWorkspaceAutoSwap);

class CWorkspaceLock;
class CWorkspaceAccess;
class CWorkspace : public IWorkspace
{
	friend class CWorkspaceAccess;
	friend class CWorkspaceLock;
	friend class CWorkspaceStringList;

public:
	CWorkspace(CString className = _T(""));
	virtual ~CWorkspace(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	ANZX\Ȋ֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXNX擾
	CWorkspaceAccess GetAccess(CString path);

	//!	ANZXNX擾AgNA
	CWorkspaceAccess GetCleanAccess(CString path);

	/////////////////////////////////////////////////////////////////////////////////////
	//	o͂Ɋւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	XMLt@C֏o
	int SaveToXMLFile(CString filePath, CString savePath = _T(""));

	//!	XMLt@C胍[h
	int LoadFromXMLFile(CString filePath);


	//!	XML֏o
	CStringA ToXMLStringUTF8(CString savePath = _T(""));

	//!	XML񂩂琶
	int FromXMLStringUTF8(CStringA xml);

	//!	XML֏o
	CString ToXMLString(CString savePath = _T(""));

	//!	XML񂩂琶
	int FromXMLString(CStringA xml);

	/////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	[hI[
	void SetReadOnly(int readOnly);

	//!	u
	void SetAutoSwap(IWorkspaceAutoSwapPtr autoSwap)
	{
		m_autoSwap = autoSwap;
	};

	//!	u
	void SetAutoSwapDefault(IWorkspaceAutoSwapPtr autoSwap)
	{
		m_autoSwapDefault = autoSwap;
	};

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(LPCSTR path);

	//!	Rs[
	virtual void Copy(LPCSTR destPath, LPCSTR srcPath, IWorkspacePtr srcWorkspace = NULL);

	/////////////////////////////////////////////////////////////////////////////////////
	//	r
	/////////////////////////////////////////////////////////////////////////////////////
	//!	bN
	virtual void Lock() { m_scopeLock.Lock(); };

	//!	AbN
	virtual void Unlock() { m_scopeLock.Unlock(); };

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyData(LPCSTR path, LPCSTR data, int noCase = FALSE);

	//!	f[^̎擾
	virtual void GetKeyData(IAPIPassStringPtr dest, LPCSTR path, LPCSTR defaultData, int noCase = FALSE);

	//!	L[
	virtual int FindKeyData(LPCSTR path, LPCSTR sData, int noCase = FALSE, int pathCompare = FALSE);

	//!	f[^̍폜
	virtual void DeleteKey(LPCSTR path);

	//!	L[擾
	virtual int GetKeyCount(LPCSTR path);

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKey(LPCSTR path, IAPIPassStringArrayPtr list);

	//!	SẴf[^𕶎ƂĎ擾
	virtual int GetAllData(LPCSTR path, IAPIPassStringArrayPtr list);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(LPCSTR path);

	//!	Tum[h𓾂
	virtual int GetSubNodeCount(LPCSTR path);

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(LPCSTR path, IAPIPassStringArrayPtr list);


protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	̑̏
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[hpXɕύX
	CString ToNodePath(CString path);

	//!	Tum[h̃|C^擾
	CWorkspaceNode	*GetSubNode(CString path, CString &key);

	//!	Rs[
	void InternalCopy(CWorkspaceNode *dest, CString srcPath);

	//!	Rs[(OC^tF[Xp)
	void ExternalCopy(IWorkspace *src, CString srcPath, CString destPath);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Ɨ̈̃[g
	CWorkspaceNode		m_root;

	//!	bNIuWFNg
	CCriticalSection	m_scopeLock;

	//!	NX
	CString				m_className;

	//!	[hI[
	int					m_readOnly;

	//!	u
	IWorkspaceAutoSwapPtr	m_autoSwap;

	//!	u(ftHg)
	IWorkspaceAutoSwapPtr	m_autoSwapDefault;

private:
	//!	Rs[֎~
	CWorkspace(const CWorkspace &other);
	void operator=(const CWorkspace &other);
};


/*!
	[NXy[XbNNX
*/
class CWorkspaceLock
{
public:
	CWorkspaceLock(CWorkspaceAccess wa)
	{
		m_ws = wa.GetRoot();
		m_ws->Lock();
	};

	virtual ~CWorkspaceLock()
	{
		m_ws->Unlock();
	};


	IWorkspace	*m_ws;
};


#define	WORKSPACE_LOCK(x) CWorkspaceLock __lock(x);

