#pragma once

template< class TYPE >
class CSimplePtrTempCopy;

/*!
	ėpI[g|C^()
	Rs[ÕNX̓|C^
*/
template< class TYPE >
class CSimplePtr
{
	friend class CSimplePtrTempCopy<TYPE>;

public:
	////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////
	//!	
	CSimplePtr<TYPE>()
	{
		m_ptr = NULL;
	};

	//!	Rs[RXgN^
	CSimplePtr<TYPE>(const TYPE *ptr)
	{
		m_ptr = NULL;

		Attach(ptr);
	};

	//!	Rs[
	void operator=(const TYPE *ptr)
	{
		Attach(ptr);
	};

	//!	蓖
	virtual void Attach(const TYPE *ptr)
	{
		//	폜
		Delete();

		m_ptr = const_cast<TYPE*>(ptr);
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[iRs[EmptyɂȂj
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CSimplePtr<TYPE>(const CSimplePtr<TYPE> &other)
	{
		m_ptr = NULL;

		Attach(const_cast<CSimplePtr<TYPE> &>(other).m_ptr);
		const_cast<CSimplePtr<TYPE> &>(other).Detach();
	};

	//!	Rs[
	void operator=(const CSimplePtr<TYPE> &other)
	{
		Attach(const_cast<CSimplePtr<TYPE> &>(other).m_ptr);
		const_cast<CSimplePtr<TYPE> &>(other).Detach();
	};

	////////////////////////////////////////////////////////////////////////////////////
	//	I
	////////////////////////////////////////////////////////////////////////////////////
	//!	fXgN^
	virtual ~CSimplePtr<TYPE>()
	{
		//	폜
		Delete();
	};

	//!	I
	virtual void Delete()
	{
		if(m_ptr)
			delete m_ptr;
		m_ptr = NULL;
	};

	//!	J(폜͂Ȃ)
	virtual void Detach()
	{
		m_ptr = NULL;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	̑
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	r
	int operator==(const CSimplePtr<TYPE> &other)
	{
		return(m_ptr == other.m_ptr);
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ptr != NULL);

		return m_ptr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ptr != NULL);

		return *m_ptr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ptr == NULL);
	};

	//!	ꎞRs[擾
	CSimplePtrTempCopy<TYPE> GetTempCopy()
	{
		return CSimplePtrTempCopy<TYPE>(*this);
	};


protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	|C^
	TYPE				*m_ptr;
};


/*!
	ėpI[g|C^(Ȃ)
	Rs[ÕNX|C^
*/
template< class TYPE >
class CSimplePtrTempCopy
{
	friend class CSimplePtr<TYPE>;

public:
	////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////
	//!	CSimplePtrTempCopy
	CSimplePtrTempCopy<TYPE>()
	{
		m_ptr = NULL;
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CSimplePtrTempCopy<TYPE>(CSimplePtr<TYPE> &other)
	{
		m_ptr = NULL;

		Attach(other.m_ptr);
	};

	//!	蓖
	virtual void Attach(TYPE *ptr)
	{
		//	폜
		Detach();

		m_ptr = ptr;
	}

public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CSimplePtrTempCopy<TYPE>(CSimplePtrTempCopy<TYPE> &other)
	{
		m_ptr = NULL;

		Attach(other.m_ptr);
	};

	//!	Rs[
	void operator=(CSimplePtrTempCopy<TYPE> &other)
	{
		Attach(other.m_ptr);
	};


	////////////////////////////////////////////////////////////////////////////////////
	//	I
	////////////////////////////////////////////////////////////////////////////////////
	//!	fXgN^
	virtual ~CSimplePtrTempCopy<TYPE>()
	{
		//	J
		Detach();
	};

	//!	J(폜͂Ȃ)
	virtual void Detach()
	{
		m_ptr = NULL;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	̑
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	r
	int operator==(const CSimplePtrTempCopy<TYPE> &other)
	{
		return(m_ptr == other.m_ptr);
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ptr != NULL);

		return m_ptr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ptr != NULL);

		return *m_ptr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ptr == NULL);
	};

	//!	ꎞRs[擾
	CSimplePtrTempCopy<TYPE> GetTempCopy()
	{
		return CSimplePtrTempCopy<TYPE>(*this);
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	|C^
	TYPE	*m_ptr;
};
