#pragma once

#include "IServerTool.h"
#include "SettingManager.h"
#include "NewConnectionQueue.h"
#include "ListenerManager.h"
#include "ConnectionManager.h"
#include "ServerStatusManager.h"
#include "ResponseManager.h"
#include "FilterManager.h"
#include "InterfaceManager.h"
#include "SupportManagers.h"


class CServer : protected IServerTool, protected IServerControl
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerControlC^[tF[X擾
	IServerControlPtr GetIServerControl() { return this; };

	//!	fobO
	void Dump();

protected:
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerToolC^[tF[X擾
	IServerToolPtr GetIServerTool() { return this; };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerControl
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o̊Jn
	virtual void StartServer();

	//!	T[o̒~
	virtual void StopServer();

	//!	ReLXg擾
	virtual void DuplicateCurrentContext(CWorkspace &contextRoot);

	//!	T[oXe[^X擾
	virtual void DuplicateServerStatus(CWorkspace &statusRoot);


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerTool
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	virtual void WriteSystemLog(LPCSTR callerName, int logType, LPCSTR logString);

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatus(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo = "", LPCSTR statusType = "String");

	//!	T[obZ[Wʒm
	virtual void NotifyServerMessage(LPCSTR messageID, LPCSTR message, int messageType, int autoOffTimeSec = -1);


	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section);


	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface);

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface);

	//!	C^tF[Xw肵Ď擾
	virtual void *GetManagerInterface(LPCSTR managerName, int interfaceVersion);


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃNX
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X}l[W
	CInterfaceManager		m_interfaceManager;

	//!	ݒ}l[W
	CSettingManager			m_settingManager;

	//!	Xe[^X}l[W
	CServerStatusManager	m_statusManager;

	//!	⏕}l[W
	CSupportManagers		m_supportManagers;


	//!	Xi
	CListenerManager		m_listenerManager;

	//!	X|X}l[W
	CResponseManager		m_responseManager;

	//!	tB^}l[W
	CFilterManager			m_filterManager;

	//!	ڑ}l[W
	CConnectionManager		m_connectionManager;


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[os
	CInterlockCounter		m_serverRunning;
};
