#include "StdAfx.h"
#include "FilterControl.h"

CFilterControl::CFilterControl(void)
{
}

CFilterControl::~CFilterControl(void)
{
	DetachFilters();
}



//////////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CFilterControl::AttachFilters(CIConnectionToolWrap connectionTool)
{
	m_connectionTool = connectionTool;
	m_threadStatus = m_connectionTool.GetIConnectionThreadStatus();

	//	tB^AC擾
	((IFilterManagerPtr)m_connectionTool.GetIServerTool().
		GetManagerInterface(FILTER_MANAGER_INTERFACE_NAME, FILTER_MANAGER_INTERFACE_VER))->GetFilterArray(m_filters);

	//!	Jn
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_START);
		m_filters[i]->Start(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	I
*/
void CFilterControl::DetachFilters()
{
	//	~
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_STOP);
		m_filters[i]->Stop(m_connectionTool.GetIConnectionTool());
	}

	m_filters.RemoveAll();
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	tB^
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_
*/
void CFilterControl::FilterRequestHeader()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_REQUEST_HEADER);
		m_filters[i]->FilterRequestHeader(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	{fBMAJԂ(throw)
*/
void CFilterControl::FilterRequestBody(CBinaryData &body)
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_REQUEST_BODY);
		m_filters[i]->FilterRequestBody(m_connectionTool.GetIConnectionTool(), body.GetCoreInterface());
	}
}

/*!
	M
*/
void CFilterControl::FilterEndRequest()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_END_REQUEST);
		m_filters[i]->FilterEndRequest(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	X|X
*/
void CFilterControl::FilterBuildResponse()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_BUILD_RESPONSE);
		m_filters[i]->FilterBuildResponse(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	X|Xwb_
*/
void CFilterControl::FilterResponseHeader()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_RESPONSE_HEADER);
		m_filters[i]->FilterResponseHeader(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	{fB𑗐MAJԂ(throw)
*/
void CFilterControl::FilterResponseBody(CBinaryData &body)
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_RESPONSE_BODY);
		m_filters[i]->FilterResponseBody(m_connectionTool.GetIConnectionTool(), body.GetCoreInterface());
	}
}

/*!
	M
*/
void CFilterControl::FilterEndResponse()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_END_RESPONSE);
		m_filters[i]->FilterEndResponse(m_connectionTool.GetIConnectionTool());
	}
}

/*!
	X|Xwb_(OցI)
*/
void CFilterControl::FilterServerResponse(CBinaryData &body)
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_SERVER_RESPONSE);
		m_filters[i]->FilterServerResponse(m_connectionTool.GetIConnectionTool(), body.GetCoreInterface());
	}
}
