#pragma once

#include "IFilter.h"
#include "Settings.h"
#include "ServerToolWrap.h"
#include "SyncObject.h"
#include "ModuleInterface.h"
#include "SimpleManagerInterfaceImplement.h"

//!	C^tF[X
#define	FILTER_MANAGER_INTERFACE_NAME	"IFilterManager"

//!	C^tF[Xo[W
#define	FILTER_MANAGER_INTERFACE_VER	1


//!	tB^AC
class CFilterArray : public CArray<CIFilterWrapper> {};



/*!
	tB^[}l[WC^tF[X
*/
class IFilterManager
{
public:
	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters) = 0;
};
typedef IFilterManager* IFilterManagerPtr;


/*!
	tB^[}l[W
*/
class CFilterManager : public IFilterManager
{
public:
	CFilterManager(void);
	virtual ~CFilterManager(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterManager
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	{tB^ǉ
	void AddBasicFilters();

	//!	tB^ǉ
	void AddFilterFactory(IFilterFactoryPtr factory, int filterLevel);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	tB^t@NgǗNX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^t@NgǗNX
	class CFilterFactoryArrayItem
	{
	public:
		//!	RXgN^
		CFilterFactoryArrayItem()
		{
		}

		//!	RXgN^
		CFilterFactoryArrayItem(CIFilterFactoryWrapper factory, int filterLevel)
		{
			m_filterFactory = factory;
			m_filterLevel = filterLevel;
		}

		//////////////////////////////////////////////////////////////////////////////////////////////
		//	bp
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	x擾
		int GetFilterLevel()
		{
			return m_filterLevel;
		}

		//!	
		void Start(IServerToolPtr serverTool)
		{
			m_filterFactory->Start(serverTool);
		}

		//!	~
		void Stop()
		{
			m_filterFactory->Stop();
		}

		//!	tB^擾
		IFilterPtr GetFilter()
		{
			return m_filterFactory->GetFilter();
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	tB^t@Ng
		CIFilterFactoryWrapper	m_filterFactory;

		//!	D揇
		int						m_filterLevel;
	};

	//!	tB^t@NgAC
	class CFilterFactoryArray : public CArray<CFilterFactoryArrayItem> {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter					m_init;

	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	ݒ
	CFilterManagerSetting				m_setting;

	//!	t@Ng
	CFilterFactoryArray					m_filterFactorys;
};

