#include "StdAfx.h"
#include "ResponseManager.h"
#include "IResponse.h"
#include "FileResponse.h"
#include "DirectoryIndexResponse.h"

/*!
	X|Xx
*/
enum RESPONSE_LEVEL
{
	RESPONSE_LEVEL_CGI			= 400000,

	RESPONSE_LEVEL_DIRECTORY	= 500000,

	RESPONSE_LEVEL_FILE			= 1000000,
};

CResponseManager::CResponseManager(void)
{
}

CResponseManager::~CResponseManager(void)
{
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CResponseManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	m_serverTool = serverTool;

	//	WX|Xǉ
	AddBasicResponses();

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i].Start(m_serverTool.GetIServerTool());

	//	C^tF[X
	m_managerInterface.Init((IResponseManagerPtr)this, RESPONSE_MANAGER_INTERFACE_VER);

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(RESPONSE_MANAGER_INTERFACE_NAME, m_managerInterface.GetIManagerInterface());
}

/*!
	~
*/
void CResponseManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i].Stop();

	m_responseFactorys.RemoveAll();

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(RESPONSE_MANAGER_INTERFACE_NAME, m_managerInterface.GetIManagerInterface());
}


/*!
	X|X
*/
IResponsePtr CResponseManager::GetResponse(CContext context)
{
	SCOPE_LOCK();

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
	{
		if(m_responseFactorys[i].IsYourRequest(context.GetIWorkspaceAccess()))
			return m_responseFactorys[i].GetResponse();
	}

	return NULL;	//	NULLԂ
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	⏕
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	{X|Xǉ
*/
void CResponseManager::AddBasicResponses()
{
	//	fBNgX|X
	AddResponsesFactory((new CDirectoryIndexResponseFactory())->GetIResponseFactory(),	RESPONSE_LEVEL_DIRECTORY);

	//	t@CX|X
	AddResponsesFactory((new CFileResponseFactory())->GetIResponseFactory(),			RESPONSE_LEVEL_FILE);
}

/*!
	X|Xǉ
*/
void CResponseManager::AddResponsesFactory(IResponseFactoryPtr factory, int responseLevel)
{
	//	}ꏊ
	for(int i=0;i<m_responseFactorys.GetSize();i++)
	{
		if(m_responseFactorys[i].GetResponseLevel() > responseLevel)
		{
			//	}
			m_responseFactorys.InsertAt(i, CResponseFactoryArrayItem(CIResponseFactoryWrapper::CreateWrapper(factory), responseLevel));
			return;
		}
	}

	//	Ō
	m_responseFactorys.Add(CResponseFactoryArrayItem(CIResponseFactoryWrapper::CreateWrapper(factory), responseLevel));
}

