#pragma once


#pragma once

template<int INTERNAL_BUF_SIZE = 256>
class CWorkspaceString
{
public:
	CWorkspaceString(void)
	{
		InternalInit();
	}

	CWorkspaceString(const CWorkspaceString &other)
	{
		InternalInit();

		*this = other;
	}

	CWorkspaceString(const CString &other)
	{
		InternalInit();

		*this = other;
	}

	CWorkspaceString(const LPSTR other)
	{
		InternalInit();

		*this = other;
	}

	virtual ~CWorkspaceString(void)
	{
		//	JĂ
		if(m_heapBuf)
			delete m_heapBuf;

		InternalInit();
	}

	/*!
		
	*/
	void InternalInit()
	{
		m_strLen = 0;
		m_heapLen = 0;
		m_heapBuf = NULL;

		//	󕶎
		GetString()[0] = 0;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	LPCSTR
	operator LPCSTR() const
	{
		return const_cast<CWorkspaceString *>(this)->GetString();
	}

	//!	LPSTR
	operator LPSTR()
	{
		return GetString();
	}

	//!	TCY擾
	int GetLength() const
	{
		return m_strLen;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CWorkspaceString
	void operator=(const CWorkspaceString &_other)
	{
		CWorkspaceString &other = const_cast<CWorkspaceString&>(_other);
		Copy(other, other.GetLength());
	}

	//!	CString
	void operator=(const CString &_other)
	{
		CString &other = const_cast<CString&>(_other);
		Copy(other, other.GetLength());
	}

	//!	LPCSTR
	void operator=(LPCSTR other)
	{
		Copy(other, strlen(other));
	}

	//!	char
	void operator=(LPSTR other)
	{
		Copy(other, strlen(other));
	}


	//////////////////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CWorkspaceString
	int operator==(const CWorkspaceString &_other)
	{
		CWorkspaceString &other = const_cast<CWorkspaceString&>(_other);
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	CString
	int operator==(const CString &_other)
	{
		CString &other = const_cast<CString&>(_other);
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	LPCSTR
	int operator==(LPCSTR other)
	{
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	LPCSTR
	int operator==(LPSTR other)
	{
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	ʂɔr
	int Compare(LPCSTR &other)
	{
		return(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)));
	}

	//!	r
	int CompareNoCase(LPCSTR &other)
	{
		return(_mbsicmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)));
	}


protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////
	/*!
		m
	*/
	void ReSize(int size)
	{
		size ++;

		//	mہH
		if(m_heapBuf == NULL && size <= INTERNAL_BUF_SIZE)
			return;

		//	mەsvH
		if(m_heapBuf != NULL && size <= m_heapLen)
			return;

		//	m
		if(m_heapBuf)
			delete m_heapBuf;
		m_heapBuf = new char[size];
		m_heapLen = size;
	}


	/*!
		Rs[
	*/
	void Copy(LPCSTR src, int len)
	{
		ReSize(len);

		//	Rs[
		memcpy(GetString(), src, len + 1);
		m_strLen = len;
	}

	//!	̎擾
	LPSTR GetString()
	{
		if(m_heapBuf != NULL)
			return m_heapBuf;
		return m_stackBuf;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	̒
	int			m_strLen;

	//!	mۃ
	char		m_stackBuf[INTERNAL_BUF_SIZE];

	//!	q[v
	char		*m_heapBuf;

	//!	q[v̒
	int			m_heapLen;
};


//!	WTCY
typedef CWorkspaceString<256> CWorkspaceString255;
