/*!
	ProtocolSocket.h

	HTTPʐMNX
*/
#pragma once
#include "BufferdSocket.h"
#include "BinaryData.h"

/*!
	HTTPʐMNX

	CBufferdSocket -> CProtocolSocket -> CSSLSocket(I[o[CgCBufferdSocket̊֐)	
	^CAEgA^CAEg͖ʐMԂŊ֐ĂяoԂł͂Ȃ

	wb_ḾAASCIIR[hȊO(\0 or >= 0x80)wb_ɌoƎs
*/
class CProtocolSocket :
	public CBufferdSocket
{
public:
	CProtocolSocket(void);
	virtual ~CProtocolSocket(void);

	//////////////////////////////////////////////////////////////////////////////////
	//	o()
	//////////////////////////////////////////////////////////////////////////////////
	//!	M
	virtual int Send(const char *data, int len);

	//!	Mij
	int SendString(const CUTF8String str);

	//!	MiCBinaryDataj
	int SendBinary(CBinaryData &data);


	//!	M
	virtual int Recv(char *data, int len);

	//!	MiCBinaryDataj
	int RecvBinary(CBinaryData &data, int maxSize);


	//!	M݂
	virtual int Peek(char *data, int len);

	//!	M݂iCBinaryDataj
	int PeekBinary(CBinaryData &data, int maxSize);


	//////////////////////////////////////////////////////////////////////////////////
	//	vgR
	//////////////////////////////////////////////////////////////////////////////////
	//!	NGXgM҂
	int WaitNextRequest(int maxWaitTime);

	//!	wb_M
	int RecvProtocolHeader(CUTF8String &head, CUTF8String endToken, int maxHeaderSize, int isPeek = FALSE);

	//////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	//////////////////////////////////////////////////////////////////////////////////
	//!	^CAEgԂݒ
	void SetTimeout(int timeoutMS) { m_timeoutMS = timeoutMS; };

protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	vgR
	//////////////////////////////////////////////////////////////////////////////////
	//!	wb_`FbN
	int GetHeaderFromBuf(CBinaryData &head, CUTF8String endToken, int maxHeaderSize, int isPeek = FALSE);

	//!	ׂASCIImF
	int CheckAllAscii(CBinaryData &head);

	//////////////////////////////////////////////////////////////////////////////////
	//	G[
	//////////////////////////////////////////////////////////////////////////////////
	//!	G[R[h當擾
	virtual CUTF8String GetErrorString(int errorCode);

	//!	G[R[h
	enum
	{
		CPS_ERROR_RECV_HEADER_OVER_SIZE = 2000,
	}CPS_ERROR_CODE;

protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////
	//!	^CAEg
	int	m_timeoutMS;
};
