#include "StdAfx.h"
#include "CnotextManager.h"
#include "DateUtility.h"

CCnotextManager::CCnotextManager(void)
{
	m_context = m_contextRoot.GetAccess("Context::Context");
	m_contextLog = m_contextRoot.GetAccess("Context::ContextLog");

	m_maxConetextLog = 0;
	m_contextID = 0;
}

CCnotextManager::~CCnotextManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
//!	
void CCnotextManager::Start(IServerToolIIPtr serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	ݒ擾
	m_setting = serverTool->GetManagerSetting(m_setting.GetSettingName());

	//	ő働O擾
	m_maxConetextLog = m_setting.GetMaxContextLogCount();
}

/*!
	~
*/
void CCnotextManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	IConetextManager
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ReLXg̃Rs[
*/
void CCnotextManager::CopyContext(CWorkspaceAccess context)
{
	WORKSPACE_LOCK(m_context);

	//	Rs[
	context.Copy(m_contextRoot.GetAccess("Context"));
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	IConetextGene
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ReLXg̎擾
*/
CContext CCnotextManager::GetNewContext(LONG connectionID)
{
	//	O
	CString	contextName;
	contextName.Format("Request_%08x", m_contextID);
	m_contextID.IncCounter();

	//	ReLXg
	CContext	context = m_context.GetAccess(contextName);

	//	ݒ
	context.SetName(contextName);			//	O
	GetDate(context.GetStartTime());		//	
	context.SetStatus("ł...");	//	
	context.SetConnectionID(connectionID);	//	ڑID

	return(context);
}

/*!
	ReLXg̔j
*/
void CCnotextManager::ReleaseContext(CContext context)
{
	//	O擾
	CString name = context.GetName();

	//	IԐݒ
	GetDate(context.GetEndTime());		//	

	//	Oړ
	if(m_maxConetextLog > 0)
	{
		//	ꎞIɃbN
		WORKSPACE_LOCK(m_context);

		//	ORs[
		m_contextLog.GetAccess(name).Copy(context);

		//	O̒
		if(m_contextLog.GetSubNodeCount() > m_maxConetextLog)
		{
			CStringArray	nodes;
			m_contextLog.GetAllSubNode(nodes);
			m_contextLog.DeleteNode(nodes[0]);
		}
	}

	//	폜
	m_context.DeleteNode(name);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
 *	t擾
 */
void CCnotextManager::GetDate(CContextDate date)
{
	//	NA
	date.Clear();

	//	
	CTime	time=CTime::GetCurrentTime();
	date.SetDate(time.Format("%Y/%m/%d"));
	date.SetTime(time.Format("%H:%M:%S"));
	date.SetGMT(CDateUtility::GetGMTString(time));
	date.SetTIME_T(time.GetTime());
}
