/*!
	T[oc[C^tF[X
*/

#pragma once
#include "InternalInterfaceTemplate.h"
#include "Workspace.h"
#include "ServerStatus.h"

//!	C^[tF[X錾
class IServerTool;
class IResponseManager;
class IFilterManager;
DEFINE_INTERNAL_INTERFACE_NOWRAP(IServerTool);
DEFINE_INTERNAL_INTERFACE_NOWRAP(IResponseManager);	//	IServerToolŎgpĂ邽߁AŒ`
DEFINE_INTERNAL_INTERFACE_NOWRAP(IFilterManager);	//	IServerToolŎgpĂ邽߁AŒ`


//!	T[oXe[^XR[h
enum
{
	SERVER_STATUS_NORMAL		= 10,
	SERVER_STATUS_NORMAL_LOG	= 0,
	SERVER_STATUS_WARNING		= -10,
	SERVER_STATUS_ERROR			= -20,
	SERVER_STATUS_FATAL_ERROR	= -30,
};


/*!
	T[opc[
*/
class IServerTool
{
public:
	//!	fXgN^
	virtual ~IServerTool() {};

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	}l[W̌ʐݒ擾
	virtual CWorkspaceAccess GetManagerSetting(CString section) = 0;

	//!	tB^̌ʐݒ擾
	virtual CWorkspaceAccess GetFilterSetting(CString section) = 0;

	//!	X|X̌ʐݒ擾
	virtual CWorkspaceAccess GetResponseSetting(CString section) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime = -1) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CString statusName, int status, CString statusInfo = "") = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CString statusName, CString status, CString statusInfo = "") = 0;

	//!	݂̃T[oXe[^X擾
	virtual CServerStatus GetServerStatus() = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o[c[VKɎ擾
	virtual IServerToolIIPtr GetIServerTool() = 0;

	//!	X|X}l[W擾
	virtual IResponseManagerIIPtr GetIResponseManager() = 0;

	//!	tB^}l[W擾
	virtual IFilterManagerIIPtr GetIFilterManager() = 0;
};




/*!
	T[op
*/
class IServerControl
{
public:
	//!	fXgN^
	virtual ~IServerControl() {};

	//!	T[o̊Jn
	virtual void StartServer() = 0;

	//!	T[o̒~
	virtual void StopServer() = 0;

	//!	݂̃T[oXe[^X擾
	virtual CServerStatus GetServerStatus() = 0;

	//!	݂̐ڑXe[^X擾
	virtual CWorkspaceAccess GetConnectionInfo() = 0;
};

//!	錾
DEFINE_INTERNAL_INTERFACE_NOWRAP(IServerControl);
