#include "StdAfx.h"
#include "ManagedInterfaceAccess.h"
#include "ServerException.h"


/*!
	RXgN^
*/
CManagedInterfaceAccess::CManagedInterfaceAccess()
{
	m_mapper = NULL;
	m_ifPath.Empty();
}

/*!
	RXgN^
*/
CManagedInterfaceAccess::CManagedInterfaceAccess(IManagedInterfaceMapperPtr mapper, CString ifPath)
{
	m_mapper = mapper;
	m_ifPath = ifPath;
}

/*!
	RXgN^
*/
CManagedInterfaceAccess::CManagedInterfaceAccess(CManagedInterfaceAccess &other)
{
	m_mapper = other.m_mapper;
	m_ifPath = other.m_ifPath;
}

/*!
	Rs[
*/
void CManagedInterfaceAccess::operator=(CManagedInterfaceAccess &other)
{
	m_mapper = other.m_mapper;
	m_ifPath = other.m_ifPath;
}


///////////////////////////////////////////////////////////////////
//	֐s
///////////////////////////////////////////////////////////////////
/*!
	Ăяos
*/
void CManagedInterfaceAccess::Invoke(CString funcName, CManagedInterfaceAccessArgStack &stack)
{
	ASSERT(m_mapper != NULL);

	//	Ăяo
	if(m_mapper->Invoke(m_ifPath, funcName, &stack))
		throw CManagedInterfaceException(MI_EXCEPTION_TYPE_INVALID_FUNC);

	//	O`FbN
	CheckAndRelayException(stack);
}

/*!
	֐̑݃`FbN
*/
int CManagedInterfaceAccess::FunctionIsExist(CString funcName)
{
	ASSERT(m_mapper != NULL);

	//	`FbN
	return m_mapper->FunctionIsExist(m_ifPath, funcName);
}

///////////////////////////////////////////////////////////////////
//	qC^tF[X
///////////////////////////////////////////////////////////////////
/*!
	qC^tF[X擾
*/
CManagedInterfaceAccess CManagedInterfaceAccess::GetChildInterface(CString ifName)
{
	ASSERT(m_mapper != NULL);

	//	݃`FbN
	if(!ChildInterfaceIsExist(ifName))
		throw CManagedInterfaceException(MI_EXCEPTION_TYPE_INVALID_IFPATH);

	//	
	return CManagedInterfaceAccess(m_mapper, m_ifPath + "::" + ifName);
}

/*!
	qC^tF[X̃`FbN
*/
int CManagedInterfaceAccess::ChildInterfaceIsExist(CString ifName)
{
	ASSERT(m_mapper != NULL);

	//	`FbN
	return m_mapper->InterfaceIsExist(m_ifPath + "::" + ifName);
}

///////////////////////////////////////////////////////////////////
//	⏕
///////////////////////////////////////////////////////////////////
/*!
	O`FbN
*/
void CManagedInterfaceAccess::CheckAndRelayException(CManagedInterfaceAccessArgStack &stack)
{
	//	OȂ
	if(stack.GetExceptionType() == MI_EXCEPTION_TYPE_NOEXCEPTION)
		return;

	//	C^[tF[X}bpO
	if(stack.GetExceptionType() < MI_EXCEPTION_TYPE_OTHER_EXCEPTION)
		throw CManagedInterfaceException(stack.GetExceptionType());

	//	̗̑O
	CheckAndRelayOtherException(stack.GetExceptionType(), stack.GetExceptionName(), stack.GetExceptionInfo());
}

/*!
	OO`FbN
	́Ae\tgEFAŃJX^}CY
*/
void CManagedInterfaceAccess::CheckAndRelayOtherException(int type, CString &name, CString &info)
{
	if(name == "CConnectionErrorException")
		throw CConnectionErrorException(info);
	else if(name == "CServerResponseException")
		throw CConnectionErrorException("}l[Włُ̈ȃT[oX|XO܂");
	else
		throw CConnectionErrorException("}l[Włُ̈ȗO܂");
}

