/*!
	ManagedInterfaceImplementArgStack.h

	֐Ăяô߂̈󂯓nVXe񋟂
	́AĂяo IManagedInterfaceArgStack 𐶐nB

	p	
*/
#pragma once
#include "ManagedInterfaceExchangeInterfaces.h"
#include "ManagedInterfaceAccessArgStack.h"
#include "BinaryData.h"
#include "WorkspaceAccess.h"


/************************************************************************************/
//	X^bNNX
//	X^bNC^tF[X񋟂
/************************************************************************************/
/*!
	C^tF[X󂯓npA֐񋟑p
	{^ȊO̎QƂ́AꎞIɓɃf[^ۑAIɏo
*/
class CManagedInterfaceImplementArg
{
public:
	CManagedInterfaceImplementArg()
	{
		SetArg(MI_ARG_TYPE_NODATA, NULL);
	}
	CManagedInterfaceImplementArg(int type, void *arg)
	{
		SetArg(type, arg);
	}

	///////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////
	//!	|C^ƌ^ݒ
	void SetArg(int type, void *arg)
	{
		m_argType = type;
		m_argPtr = arg;
	}

	//!	Qƌ^߂
	void FlashRefData()
	{
		if(m_argType == MI_ARG_TYPE_STR_REFERENCE)
		{
			((IStringPtr)m_argPtr)->SetString(m_strRef);
		}
		else if(m_argType == MI_ARG_TYPE_BINARY_REFERENCE)
		{
			((IBinaryData*)m_argPtr)->ReSize(m_bdRef.GetSize());
			memcpy(((IBinaryData*)m_argPtr)->GetPtr(), m_bdRef.GetPtr(), m_bdRef.GetSize());
		}
		else if(m_argType == MI_ARG_TYPE_WORKSPACE_REFERENCE)
		{
			((IWorkspaceAccessPtr)m_argPtr)->SetWorkspaceAccess(m_wsRef.GetRoot(), m_wsRef.GetPath());
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	//	p
	///////////////////////////////////////////////////////////////////////////////
	//!	Int^
	operator int()
	{
		CheckArgType(MI_ARG_TYPE_INT);
		return(*(int*)m_argPtr);
	}

	//!	Int*^
	operator int*()
	{
		CheckArgType(MI_ARG_TYPE_INT_REFERENCE);
		return((int*)m_argPtr);
	}

	//!	Int64^
	operator __int64()
	{
		CheckArgType(MI_ARG_TYPE_INT64);
		return(*(__int64*)m_argPtr);
	}

	//!	Int64*^
	operator __int64*()
	{
		CheckArgType(MI_ARG_TYPE_INT64_REFERENCE);
		return((__int64*)m_argPtr);
	}

	//!	CString^
	operator CString()
	{
		CheckArgType(MI_ARG_TYPE_STR);
		return(((IStringPtr)m_argPtr)->GetString());
	}

	//!	CString*^
	operator CString*()
	{
		CheckArgType(MI_ARG_TYPE_STR_REFERENCE);

		//	U擾
		m_strRef = ((IStringPtr)m_argPtr)->GetString();
		return(&m_strRef);
	}

	//!	CBinaryData^
	operator CBinaryData()
	{
		CheckArgType(MI_ARG_TYPE_BINARY);

		//	U擾
		m_bdRef.Empty();
		m_bdRef.Append(((IBinaryDataPtr)m_argPtr)->GetPtr(), ((IBinaryData*)m_argPtr)->GetSize());
		return(m_bdRef);
	}

	//!	CBinaryData*^
	operator CBinaryData*()
	{
		CheckArgType(MI_ARG_TYPE_BINARY_REFERENCE);

		//	U擾
		m_bdRef.Empty();
		m_bdRef.Append(((IBinaryDataPtr)m_argPtr)->GetPtr(), ((IBinaryData*)m_argPtr)->GetSize());
		return(&m_bdRef);
	}

	//!	CWorkspaceAccess^
	operator CWorkspaceAccess()
	{
		CheckArgType(MI_ARG_TYPE_WORKSPACE);
		return(CWorkspaceAccess((IWorkspaceAccessPtr)m_argPtr));
	}

	//!	CWorkspaceAccess^
	operator CWorkspaceAccess*()
	{
		CheckArgType(MI_ARG_TYPE_WORKSPACE_REFERENCE);

		//	U擾
		m_wsRef = CWorkspaceAccess((IWorkspaceAccessPtr)m_argPtr);
		return(&m_wsRef);
	}

	///////////////////////////////////////////////////////////////////////////////
	//	߂lp
	///////////////////////////////////////////////////////////////////////////////
	//!	int
	void operator=(int val)
	{
		CheckArgType(MI_ARG_TYPE_INT_REFERENCE);
		*(int*)m_argPtr = val;
	}

	//!	int64
	void operator=(__int64 val)
	{
		CheckArgType(MI_ARG_TYPE_INT64_REFERENCE);
		*(__int64*)m_argPtr = val;
	}

	//!	String
	void operator=(CString val)
	{
		CheckArgType(MI_ARG_TYPE_STR_REFERENCE);
		((IStringPtr)m_argPtr)->SetString(val);
	}

	//!	Binary
	void operator=(CBinaryData val)
	{
		CheckArgType(MI_ARG_TYPE_STR_REFERENCE);
		((IBinaryData*)m_argPtr)->ReSize(val.GetSize());
		memcpy(((IBinaryData*)m_argPtr)->GetPtr(), val.GetPtr(), val.GetSize());
	}

	//!	CWorkspaceAccess
	void operator=(CWorkspaceAccess val)
	{
		CheckArgType(MI_ARG_TYPE_WORKSPACE);
		((IWorkspaceAccessPtr)m_argPtr)->SetWorkspaceAccess(val.GetRoot(), val.GetPath());
	}

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////////////////
	//!	̊mF
	void CheckArgType(int type)
	{
		if(m_argType != type)
			throw CManagedInterfaceException();
	}

	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	^
	int						m_argType;

	//!	ʃ|C^
	void					*m_argPtr;

	//!	p
	CString					m_strRef;

	//!	BinaryData
	CBinaryData				m_bdRef;

	//!	CWorkspaceAccess
	CWorkspaceAccess		m_wsRef;
};

/*!
	C^tF[X󂯓npX^bNA֐񋟑p
*/
class CManagedInterfaceImplementArgStack
{
public:
	//!	RXgN^
	CManagedInterfaceImplementArgStack(IManagedInterfaceArgStackPtr stack)
	{
		m_stack = stack;

		//	
		int	count = m_stack->GetArgCount();
		for(int i=0;i<count;i++)
			m_args.Add(CManagedInterfaceImplementArg(m_stack->GetArgType(i), m_stack->GetArgPtr(i)));
	}

	//!	fXgN^
	virtual ~CManagedInterfaceImplementArgStack()
	{
		//	߂
		for(int i=0;i<m_args.GetCount();i++)
			m_args[i].FlashRefData();
	}

	///////////////////////////////////////////////////////////////////////////////
	//	ANZX
	///////////////////////////////////////////////////////////////////////////////
	//!	擾
	CManagedInterfaceImplementArg &operator[](int index)
	{
		if(index < 0 || index >= m_args.GetSize())
			throw CManagedInterfaceException();
		return m_args[index];
	};

	///////////////////////////////////////////////////////////////////////////////
	//	O
	///////////////////////////////////////////////////////////////////////////////
	//!	Oݒ
	void SetException(int type, LPCSTR name, LPCSTR info)
	{
		m_stack->SetException(type, name, info);
	}

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	X^bN
	IManagedInterfaceArgStackPtr	m_stack;

	//!	z
	CArray<CManagedInterfaceImplementArg>	m_args;
};
