/*!
	ManagedInterfaceMapper.h - Ǘ^C^tF[XǗNX

	RɃC^tF[Xo^E폜\Ńc[^\
	֐́AC^[tF[XpXƊ֐ŃANZX
	ȉ̗O͐ɊǗ^C^tF[X𒴂邱ƂoiǗNXŃLb`AĂяoōēxX[jB
	ECManagedInterfaceException
*/
#pragma once
#include "InternalInterfaceTemplate.h"
#include "ManagedInterfaceExchangeInterfaces.h"
#include "FastReadWriteLock.h"
#include "ManagedInterfaceRegister.h"


/************************************************************************************************/
//	Ǘ^C^tF[X@ǗNX
/************************************************************************************************/
/*!
	Ǘ^C^tF[X@ǗNX
*/
class CManagedInterfaceMapper :
	public IManagedInterfaceMapper, public IManagedInterfaceRegisterRoot
{
public:
	CManagedInterfaceMapper(void);
	virtual ~CManagedInterfaceMapper(void);

	///////////////////////////////////////////////////////////////////
	//	IMappedInterface(ǂݍ݃bN)
	///////////////////////////////////////////////////////////////////
	//!	C^tF[X݊mF
	virtual int InterfaceIsExist(LPCSTR interfacePath);

	//!	֐݊mF
	virtual int FunctionIsExist(LPCSTR interfacePath, LPCSTR funcName);

	//!	֐̎s
	virtual int Invoke(LPCSTR interfacePath, LPCSTR funcName, IManagedInterfaceArgStackPtr args);

	///////////////////////////////////////////////////////////////////
	//	IManagedInterfaceRegisterRoot(݃bN)
	///////////////////////////////////////////////////////////////////
	//!	o^
	virtual int RegisterInterface(CString ifPath, IManagedInterfaceImplementPtr toRegist, int overload);

	//!	폜
	virtual int UnRegisterInterface(CString ifPath, IManagedInterfaceImplementPtr toUnRegist);

protected:
	///////////////////////////////////////////////////////////////////
	//	⏕(zpNeBJZNVŕی)
	///////////////////////////////////////////////////////////////////
	//!	ǉ
	int AddInterface(CString ifPath, IManagedInterfaceImplementPtr regit, int overload);

	//!	C^tF[X擾
	IManagedInterfaceImplementPtr GetInterface(CString ifPath);

	//!	폜
	int DeleteInterface(CString ifPath, IManagedInterfaceImplementPtr toUnRegist);

	//!	C^tF[X猟
	int FindInterface(CString ifPath);

protected:
	///////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection						m_scopeLock;

	//!	ǂݏbN
	CFastReadWriteLock						m_readWriteLock;

	//!	C^tF[XXg
	CStringArray							m_interfacePath;

	//!	C^tF[XXg
	CTypedPtrArray<CPtrArray, IManagedInterfaceImplementPtr>	m_interface;
};
