#include "StdAfx.h"
#include "SubProcess.h"

//!	obt@TCY
#define	BUFFER_SIZE	65536

CSubProcess::CSubProcess(void)
{
	//	vZX\̏
	memset(&m_processInfo, 0 ,sizeof(m_processInfo));

	//	tONA
	m_processCreated = 0;

	//	̈揉
	ClearSubProcessEnvironment();
}

CSubProcess::~CSubProcess(void)
{
	TerminateSubProcess();

	SAFE_CLOSE_HANDLE(m_processInfo.hProcess);
	SAFE_CLOSE_HANDLE(m_processInfo.hThread);
}

///////////////////////////////////////////////////////////////////////
//	TuvZXNA
///////////////////////////////////////////////////////////////////////
/*!
	TuvZX̋N
*/
int CSubProcess::RunSubProcess(CString command, CString workPath, CString idString)
{
	//	I
	TerminateSubProcess();

	//	pCv
	if(SetupPipe(idString))
		return(-1);

	//	ϐ
	m_subProcessEnvironment.AppendWord('\0\0');

	//	vZX\
	STARTUPINFO StartupInfo;
	::ZeroMemory(&StartupInfo, sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);

	// nȟpw
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;

	// DOS\Ȃ
	StartupInfo.wShowWindow = SW_HIDE;

	// Wo̓nhƃG[o̓nhݒ
	StartupInfo.hStdInput	= m_stdIn.GetReadPipe();
	StartupInfo.hStdOutput	= m_stdOut.GetWritePipe();
	StartupInfo.hStdError	= m_stdErr.GetWritePipe();

	//	ZLeB
	SECURITY_ATTRIBUTES	sa;
	memset(&sa, 0, sizeof(sa));
	sa.lpSecurityDescriptor = NULL;
	sa.bInheritHandle = TRUE;	//	nhp

	// R\[AvN
	if (!::CreateProcess(
		NULL,
		command.GetBuffer(0),
		&sa,
		NULL,
		TRUE,				// nȟp
		0,	// DOS\Ȃ߂̎w
		m_subProcessEnvironment.GetPtr(),
		workPath,
		&StartupInfo,
		&m_processInfo))
	{
		return(-1);
	}

	m_processCreated = 1;
	return(0);
}


/*!
	vZX͎sH
*/
int CSubProcess::SubProcessIsRunning()
{
	if(!m_processCreated)
		return(FALSE);

	if(::WaitForSingleObject(m_processInfo.hProcess, 0) == WAIT_OBJECT_0)
		return(TRUE);
	return(FALSE);
}

/*!
	I
*/
void CSubProcess::TerminateSubProcess()
{
	if(SubProcessIsRunning())
	{
		::TerminateProcess(m_processInfo.hProcess, -1);
	}
	m_processCreated = 0;
}

///////////////////////////////////////////////////////////////////////
//	⏕֐
///////////////////////////////////////////////////////////////////////
/*!
	pCv
*/
int CSubProcess::SetupPipe(CString idString)
{
	//	STDIN
	if(m_stdIn.CreateOvrlappedPipe(idString + "_STDIN", BUFFER_SIZE))
		return(-1);

	//	STDOUT
	if(m_stdOut.CreateOvrlappedPipe(idString + "_STDOUT", BUFFER_SIZE))
		return(-1);

	//	STDERR
	if(m_stdErr.CreateOvrlappedPipe(idString + "_STDERR", BUFFER_SIZE))
		return(-1);

	return(0);
}

///////////////////////////////////////////////////////////////////////
//	ϐ
///////////////////////////////////////////////////////////////////////
/*!
	ϐ̒ǉ
*/
void CSubProcess::AddSubProcessEnvironment(CString env)
{
	m_subProcessEnvironment.AppendString(env);
	m_subProcessEnvironment.AppendByte('\0');
}

/*!
	ϐ̒ǉ
*/
void CSubProcess::AddSubProcessEnvironmentWorkspace(CWorkspaceAccess workspace)
{
	CStringArray	list;
	workspace.GetAllKey(list);

	//	ǉ
	for(int i=0;i<list.GetSize();i++)
		AddSubProcessEnvironment(list[i] + "=" + workspace.GetKeyStr(list[i],""));
}

/*!
	NA
*/
void CSubProcess::ClearSubProcessEnvironment()
{
	m_subProcessEnvironment.Empty();
}


