#pragma once
#include "FilterBase.h"
#include "FilterFactoryBase.h"
#include "Settings.h"
#include "SyncObject.h"
#include "ILogManager.h"
#include "TextTools.h"

class CAccessLogFilter :
	public CFilterFactoryBase, public CFilterBase
{
public:
	CAccessLogFilter(void);
	virtual ~CAccessLogFilter(void);

	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr GetFilter() { return IFilterRet(this, FALSE); };

	//!	
	virtual void StartFactory(IServerToolPtr serverTool);

	//!	~
	virtual void StopFactory();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	~
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	ؒf(OցI)
	virtual void Stop(IFilterContextPtr filterContext);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Oo
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	`FbN
	int IsIgnore(CString serverPath);

	//!	O擾
	CString	GetLogFilePath(CContext &context);

	//!	O擾
	CString	GetLog(CContext &context);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	IServerToolPtr				m_serverTool;

	//!	ݒ
	CAccessLogFilterSetting		m_setting;

	//!	O}l[W
	ILogManagerPtr				m_logManager;

	//!	t@CpX
	CLockObject<CString>		m_logFilePath;

	//!	t@CtH[}bg
	CLockObject<CString>		m_logFormat;

	//!	Url
	CStringArray				m_ignorePath;
};

