/*
	IPAddress
	IPAhX𒊏ۉ

	Version		: 0.0 (Release1)

	쐬		: 2002/05/25 (Yuh)
	C		: ----/--/--
	藚	: 
*/

#include "stdafx.h"
#include "IPAddress.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CIPAddress::CIPAddress()
{

}

CIPAddress::CIPAddress(in_addr other)
{
	*this = other;
}

CIPAddress::CIPAddress(CString other)
{
	*this = other;
}

CIPAddress::CIPAddress(DWORD other)
{
	*this = other;
}

CIPAddress::~CIPAddress()
{

}


//////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////
//	in_addr
void CIPAddress::operator=(in_addr other)
{
	m_ip = other;
}

//	񂩂
void CIPAddress::operator=(CString other)
{
	m_ip.S_un.S_addr = inet_addr(other);
}

//	DWORD
void CIPAddress::operator=(DWORD other)
{
	m_ip.S_un.S_addr = ntohl(other);
}

//	zXgw
int CIPAddress::SetIPByHostName(CString host)
{
	hostent	*ent = gethostbyname(host);
	if(ent == NULL)
		return(-1);

	sockaddr_in *in = (sockaddr_in *)ent->h_addr_list[0];
	m_ip = in->sin_addr;

	return(htons(in->sin_port));
}

//////////////////////////////////////////////////////////////////////
// 擾
//////////////////////////////////////////////////////////////////////
//	in_addr
CIPAddress::operator in_addr()
{
	return(m_ip);
}

//	
CIPAddress::operator CString()
{
	return(inet_ntoa(m_ip));
}

//	
CIPAddress::operator char*()
{
	return(inet_ntoa(m_ip));
}

//	DWORD 
CIPAddress::operator DWORD()
{
	return(htonl(m_ip.S_un.S_addr));
}

//	zXg
CString CIPAddress::GetHostName()
{
	hostent	*ent = gethostbyaddr((char *)&m_ip,sizeof(m_ip),AF_INET);
	if(ent == NULL || strlen(ent->h_name)==0)
		return(inet_ntoa(m_ip));

	return(ent->h_name);
}

//////////////////////////////////////////////////////////////////////
// r
//////////////////////////////////////////////////////////////////////
int CIPAddress::operator==(CIPAddress other)
{
	return(((in_addr)other).S_un.S_addr == m_ip.S_un.S_addr);
}

int CIPAddress::operator==(in_addr other)
{
	return(other.S_un.S_addr == m_ip.S_un.S_addr);
}

int CIPAddress::operator==(CString other)
{
	return(CIPAddress(other) == m_ip);
}
