#include "StdAfx.h"
#include "ResponseManager.h"
#include "IResponse.h"
#include "FileResponse.h"
#include "DirectoryIndexResponse.h"

CResponseManager::CResponseManager(void)
{
}

CResponseManager::~CResponseManager(void)
{
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CResponseManager::Start(IServerToolPtr serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	m_serverTool = serverTool;

	//	fBNgX|X
	m_responseFactorys.Add(IResponseFactoryRet(new CDirectoryIndexResponseFactory, TRUE));

	//	t@CX|X
	m_responseFactorys.Add(IResponseFactoryRet(new CFileResponseFactory, TRUE));

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i]->StartFactory(m_serverTool->GetIServerTool());
}

/*!
	~
*/
void CResponseManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i]->StopFactory();

	m_responseFactorys.RemoveAll();
}


/*!
	X|X
*/
IResponsePtr CResponseManager::GetResponse(CContext context)
{
	SCOPE_LOCK();

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
	{
		if(m_responseFactorys[i]->IsYourRequest(context))
			return m_responseFactorys[i]->GetResponse();
	}

	return IResponsePtr();	//	NULLԂ
}

