#include "StdAfx.h"
#include "Server.h"
#include "Dir.h"
#include "ServerStartErrorException.h"

#define	CLASS_NAME	"Server"

CServer::CServer(void)
{
}

CServer::~CServer(void)
{
	StopServer();
}



/////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerControl
/////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	T[o̊Jn
*/
void CServer::StartServer()
{
	//	sH
	if(m_serverRunning)
		return;
	m_serverRunning = TRUE;

	//	XV
	SetServerStatusStr("ServerVersion", SERVER_VERSION);
	SetServerStatusStr("ServerVersionString", SERVER_VERSION_STRING);
	SetServerStatusStr("ServerRoot", CPathTools::GetAppPath());

	//	G[
	try
	{
		//	ԍXV
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG,	"T[o̎sJn܂");

		/*
			Ǘ@\
		*/
		//	ݒ}l[W
		m_settingManager.Start(GetIServerTool());

		//	Xe[^X}l[W
		m_statusManager.Start(GetIServerTool());

		//	ANZXO}l[WN
		m_logManager.Start(GetIServerTool());

		//	pX}l[W
		m_pathManager.Start(GetIServerTool());

		//	T[oeLXg}l[WN
		m_serverTextManager.Start(GetIServerTool());

		//	MimeType}l[W
		m_mineTypeManager.Start(GetIServerTool());

		//	tB^}l[W
		m_filterManager.Start(GetIServerTool());

		//	X|X}l[WN
		m_responseManager.Start(GetIServerTool());

		/*
			ʐM@\
		*/
		//	ڑ}l[WJn
		m_connectionManager.Start(GetIServerTool());

		//	Xi
		m_listenerManager.Start(GetIServerTool(), m_connectionManager.GetIClientConnectionQueue());


		//	ԍXV
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG,	"T[ȍ܂");
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL,		"T[o͎sł");
		SetServerStatusInt("ServerRunning", 1);
	}
	catch(CServerStartErrorException err)
	{
		//	G[Zbg
		WriteSystemLog(err.m_caller, SERVER_STATUS_FATAL_ERROR, err.m_errorInfo);

		//	~
		StopServer();
	}
}

/*!
	T[o̒~
*/
void CServer::StopServer()
{
	//	sH
	if(!m_serverRunning)
		return;
	m_serverRunning = FALSE;

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG, "T[o̒~Jn܂");

	/*
		ʐM@\~
	*/
	//	ʐM~
	m_listenerManager.ShutdownListen();

	//	ڑ}l[W~
	m_connectionManager.Stop();

	//	Xi~
	m_listenerManager.Stop();


	/*
		Ǘ@\~
	*/
	//	X|X}l[W~
	m_responseManager.Stop();

	//	tB^}l[W~
	m_filterManager.Stop();

	//	MimeType}l[W~
	m_mineTypeManager.Stop();

	//	T[oeLXg}l[W~
	m_serverTextManager.Stop();

	//	pX}l[W~
	m_pathManager.Stop();

	//	ANZXO}l[W~
	m_logManager.Stop();

	//	ݒ}l[W~
	m_settingManager.Stop();

	//	Xe[^X}l[W~
	m_statusManager.Stop();

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG, "T[o̎s~܂");
	SetServerStatusInt("ServerRunning", 0);
}

