/*!
	ݒ
*/
#pragma once
#include "Workspace.h"
#include "WorkspaceStringList.h"
#include "Context.h"

/*****************************************************************************************************/
//	}l[W
/*****************************************************************************************************/
/*!
	Xbh}l[W̐ݒ
	Manager
*/
class CConnectionManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CConnectionManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "ConnectionManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	őڑ
	DEFINE_PROPERTY_METHOD_INT(MaxConnect,			"MaxConnect",		100);

	//!	I[o[[h[h
	DEFINE_PROPERTY_METHOD_INT(OverloadModeKeepTime,	"OverloadModeKeepTime",		10 * 1000);
};


/*!
	O}l[W̐ݒ
	Manager
*/
class CLogManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CLogManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "LogManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	OXV
	DEFINE_PROPERTY_METHOD_INT(UpdateInterval,	"UpdateInterval",	1000);
};


/*!
	VXeO}l[W̐ݒ
	Manager
*/
class CSystemLogManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CSystemLogManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "SystemLogManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	VXeOpX
	DEFINE_PROPERTY_METHOD_STR(SystemLogFilePath,	"SystemLogFilePath",	"%ServerRoot%Logs\\SystemLog.txt");
};


/*!
	Xi}l[W̐ݒ
	Manager
*/
class CListenerManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CListenerManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "ListenerManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	m[}XiL
	DEFINE_PROPERTY_METHOD_INT(EnableNormalListener,	"EnableNormalListener",	TRUE);

	//!	SSLXiL
	DEFINE_PROPERTY_METHOD_INT(EnableSSLListener,		"EnableSSLListener",	FALSE);
};

/*!
	m[}Xi̐ݒ
	Manager

	ʏ̐ڑɊւݒ˂
*/
class CNormalListenerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CNormalListenerSetting);

	//!	̎擾
	CString GetSettingName() { return "NormalListener"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	|[gԍ
	DEFINE_PROPERTY_METHOD_STR(Port,			"Port",				"80");		//	"80, 8080, 1080"

	//!	|[gI[vG[̃gC
	DEFINE_PROPERTY_METHOD_INT(ListenErrorRetryTime,	"ListenErrorRetryTime",		10 * 1000);

	//!	ʐM^CAEg
	DEFINE_PROPERTY_METHOD_INT(ConnectionTimeoutTime,	"ConnectionTimeoutTime",	3 * 60 * 1000);
};

/*!
	SSLXi̐ݒ
	Manager

	SSLڑɊւݒ˂
*/
class CSSLListenerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CSSLListenerSetting);

	//!	̎擾
	CString GetSettingName() { return "SSLListener"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	|[gԍ
	DEFINE_PROPERTY_METHOD_STR(Port,					"Port",						"443");		//	"80, 8080, 1080"

	//!	|[gI[vG[̃gC
	DEFINE_PROPERTY_METHOD_INT(ListenErrorRetryTime,	"ListenErrorRetryTime",		10 * 1000);

	//!	ʐM^CAEg
	DEFINE_PROPERTY_METHOD_INT(ConnectionTimeoutTime,	"ConnectionTimeoutTime",	3 * 60 * 1000);

	//!	閧
	DEFINE_PROPERTY_METHOD_STR(PrivateKey,				"PrivateKey",				"%ServerRoot%SSLKey\\04WebServer.pem");

	//!	閧pX[h
	DEFINE_PROPERTY_METHOD_STR(PrivateKeyPassword,		"PrivateKeyPassword",		"test");

	//!	T[oؖ
	DEFINE_PROPERTY_METHOD_STR(Certificate,				"Certificate",				"%ServerRoot%SSLKey\\04WebServer.crt");

	//!	ԏؖ
	DEFINE_PROPERTY_METHOD_STR(CertificateChain,		"CertificateChain",			"");
};


/*!
	ReLXg}l[W̐ݒ
	Manager
*/
class CContextManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CContextManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "ContextManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	O
	DEFINE_PROPERTY_METHOD_INT(MaxContextLogCount,	"MaxContextLogCount",	100);
};


/*!
	pX}l[W̐ݒ
	Manager
*/
class CPathManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CPathManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "PathManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	pXݒ擾
	CPathInfoList GetPathList() { return GetAccess("PathList"); };
};


/*!
	Mime^Cv}l[W̐ݒ
	Manager
*/
class CMimeTypeManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CMimeTypeManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "MimeTypeManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeTypẽeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_STR(MimeTypeText,				"MimeTypeText",					"");

	//!	MimeTypeIcoñeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_STR(MimeTypeIcocText,			"MimeTypeIconText",					"");
};


/*!
	ڑRg[̐ݒ
	Manager
*/
class CConnectionControlSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CConnectionControlSetting);

	//!	̎擾
	CString GetSettingName() { return "ConnectionControl"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeTypẽeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_INT(BlockSize,				"BlockSize",					65536);

	//!	MimeTypeIcoñeLXgɂݒ荀
	DEFINE_PROPERTY_METHOD_INT(MaxBufferingSize,		"MaxBufferingSize",				3 * 1024 * 1024);
};


/*!
	T[oeLXg}l[W̐ݒ
	Manager
*/
class CServerTextManagerSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerTextManagerSetting);

	//!	̎擾
	CString GetSettingName() { return "ServerTextManager"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	HTMLtH_
	DEFINE_PROPERTY_METHOD_STR(ServerHtmlDirectory,				"ServerHtmlDirectory",					"%ServerRoot%Html\\");
};


/*****************************************************************************************************/
//	tB^
/*****************************************************************************************************/
/*!
	IndextB^̐ݒ
	Filter
*/
class CIndexFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CIndexFilterSetting);

	//!	̎擾
	CString GetSettingName() { return "IndexFilter"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	^Cv
	DEFINE_PROPERTY_METHOD_INT(MoveMode,				"MoveMode",					0);

	//!	CfbNXXg
	CWorkspaceStringList GetIndexList() { return CWorkspaceStringList(GetAccess("IndexFileList"), "IndexFile"); };
};


/*!
	OtB^̐ݒ
	Filter
*/
class CAccessLogFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CAccessLogFilterSetting);

	//!	̎擾
	CString GetSettingName() { return "AccessLogFilter"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXOpX
	DEFINE_PROPERTY_METHOD_STR(AccessLogFilePath,	"AccessLogFilePath",	"%ServerRoot%Logs\\%Year%%Month%%Day%.txt");

	//!	ANZXOtH[}bg
	DEFINE_PROPERTY_METHOD_STR(AccessLogFormat,		"AccessLogFormat",		"[%Time%] <%ClientIP%> (%RecvSize%,%SendSize%) [%Status%] %Method% %Object%");

	//!	OɏȂpX
	DEFINE_PROPERTY_METHOD_STR(IgnorePath,			"IgnorePath",			"");	//	/icons/*, /private/*
};

/*!
	KeepAlivetB^̐ݒ
	Filter
*/
class CKeepAliveFilterSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CKeepAliveFilterSetting);

	//!	̎擾
	CString GetSettingName() { return "KeepAliveFilter"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	KeepAliveL
	DEFINE_PROPERTY_METHOD_INT(EnableKeepAlive,			"EnableKeepAlive",	1);

	//!	KeepAlive
	DEFINE_PROPERTY_METHOD_INT(MaxKeepConnectionTime,		"MaxKeepConnectionTime",	20 * 1000);

	//!	KeepAlive
	DEFINE_PROPERTY_METHOD_INT(MaxKeepConnectionCount,		"MaxKeepConnectionCount",	2);
};



/*****************************************************************************************************/
//	X|X
/*****************************************************************************************************/
/*!
	T[oX|X̐ݒ
	Response
	T[oX|X̓X|XW[ł͂ȂAɓ
*/
class CServerResponseSetting :
	protected CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerResponseSetting);

	//!	̎擾
	CString GetSettingName() { return "ServerResponse"; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
};

