#include "StdAfx.h"
#include ".\workspace.h"
#include ".\workspaceAccess.h"
#include "WorkspaceXMLReader.h"
#include "WorkspaceXMLWriter.h"
#include "TextTools.h"

//	fobO⏕
#ifndef DEBUG_OUT
	#define	DEBUG_OUT	TRACE
#endif

//	W
#define	DEFAULT_CLASS_TYPE	"CWorkspace"

//	[hI[tOmF
#define	WRITE_FUNCTION_CHECK()	if(m_readOnly) { ASSERT(0); return; };

CWorkspace::CWorkspace(CString className)
{
	if(className.IsEmpty())
		m_className = DEFAULT_CLASS_TYPE;
	else
		m_className = className;

	//	[gݒ
	m_root.SetNodeName(m_className);

	//	ǂݍݐpł͂Ȃ
	m_readOnly = 0;
}

CWorkspace::~CWorkspace(void)
{
}


/*********************************************************
	ANZX\Ȋ֐
**********************************************************/
/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspace::GetAccess(CString path)
{
	return CWorkspaceAccess(this,path);
}


/*!
	ANZXNX擾AgNA
*/
CWorkspaceAccess CWorkspace::GetCleanAccess(CString path)
{
	CWorkspaceAccess ret = CWorkspaceAccess(this, path);
	ret.Clear();
	return ret;
}


/////////////////////////////////////////////////////////////////////////////////////
//	o͂Ɋւ鏈
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XMLt@C֏o
*/
int CWorkspace::SaveToXMLFile(CString filePath, CString savePath)
{
	SCOPE_LOCK();

	try
	{
		//	ۑm[h̎擾
		CString key;
		CWorkspaceNode * node = GetSubNode(savePath,key);

		//	ۑ
		CWorkspaceXMLWriter	writer;
		writer.SaveToFile(&m_root, filePath, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}

/*!
	XMLt@C胍[h
*/
int CWorkspace::LoadFromXMLFile(CString filePath)
{
	SCOPE_LOCK();

	try
	{
		//	NA
		m_root.Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.LoadFromFile(&m_root, filePath, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}


/*!
	XML֏o
*/
CStringA CWorkspace::ToXMLStringUTF8(CString savePath)
{
	SCOPE_LOCK();

	return(CTextTools::StrToUTF8(ToXMLString(savePath).GetBuffer(0)));
}

/*!
	XML񂩂琶
*/
int CWorkspace::FromXMLStringUTF8(CStringA xml)
{
	SCOPE_LOCK();

	return(FromXMLString(CTextTools::UTF8ToANSIStr(xml.GetBuffer(0))));
}

/*!
	XML֏o
*/
CString CWorkspace::ToXMLString(CString savePath)
{
	SCOPE_LOCK();

	try
	{
		//	ۑm[h̎擾
		CString key;
		CWorkspaceNode * node = GetSubNode(savePath,key);

		//	ۑ
		CWorkspaceXMLWriter	writer;
		return(writer.ToString(&m_root, m_className));
	}
	catch(CWorkspaceXMLWriterException err)
	{
		TRACE("XML LoadError : %s\n", err.m_error);
		return("");
	}
}

/*!
	XML񂩂琶
*/
int CWorkspace::FromXMLString(CStringA xml)
{
	SCOPE_LOCK();


	try
	{
		//	NA
		m_root.Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.FromString(&m_root, xml, m_className);
	}
	catch(CXMLTextParserException err)
	{
		TRACE("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}

/*********************************************************
	Ȃ
**********************************************************/
/*!
	Sf[^NA
*/
void CWorkspace::Clear(LPCSTR _path)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path, key);

	node->Clear();
}


/*!
	Rs[

	srcConfigɕʂCWorkspaceNXw肷ƁAʂ̃NXփRs[ł
*/
void CWorkspace::Copy(LPCSTR _destPath, LPCSTR _srcPath, IWorkspacePtr srcWorkspace)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString destPath = ToNodePath(_destPath);
	CString srcPath = ToNodePath(_srcPath);

	if(srcWorkspace==NULL || srcWorkspace==this)
	{
		CString key;
		CWorkspaceNode * dNode = GetSubNode(destPath, key);
		InternalCopy(dNode,srcPath);
	}
	else
	{
		/*
		//	_ELXg݂
		CWorkspace *src = dynamic_cast<CWorkspace*>(srcWorkspace);
		if(src != NULL)
		{
			src->Lock();

			CString key;
			CWorkspaceNode * dNode = GetSubNode(destPath, key);
			src->_Copy(dNode, srcPath);

			src->Unlock();
		}
		else
		{
			srcWorkspace->Lock();
			srcWorkspace->Unlock();
		}
		*/

		srcWorkspace->Lock();
		ExternalCopy(srcWorkspace, _srcPath, _destPath);
		srcWorkspace->Unlock();
	}
}



/*********************************************************
	KeyɊւ鏈
**********************************************************/
/*!
	f[^̐ݒ
*/
void CWorkspace::SetKeyData(LPCSTR path, LPCSTR data, int noCase)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->SetKeyData(key, data, noCase);
}


/*!
	f[^̎擾
*/
void CWorkspace::GetKeyData(IAPIPassStringPtr dest, LPCSTR path, LPCSTR defaultData, int noCase)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	if(!m_autoSwap.IsEmpty())
		dest->SetString(m_autoSwap->GetKeyDataSwap(this, key, node->GetKeyData(key, defaultData, noCase)));
	else
	{
		if(!m_autoSwapDefault.IsEmpty())
			dest->SetString(node->GetKeyData(key, m_autoSwapDefault->GetKeyDataSwap(this, key, defaultData), noCase));
		else
			dest->SetString(node->GetKeyData(key, defaultData, noCase));
	}
}


/*!
	L[
*/
int CWorkspace::FindKeyData(LPCSTR path, LPCSTR sData, int noCase, int pathCompare)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->FindKeyData(sData, noCase, pathCompare));
}


/*!
	f[^̍폜
*/
void CWorkspace::DeleteKey(LPCSTR path)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->DeleteKey(key);
}


/*!
	L[擾
*/
int CWorkspace::GetKeyCount(LPCSTR _path)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetKeyCount());
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspace::GetAllKey(LPCSTR _path, IAPIPassStringArrayPtr list)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetAllKey(list));
}

/*!
	SẴf[^𕶎ƂĎ擾
*/
int CWorkspace::GetAllData(LPCSTR _path, IAPIPassStringArrayPtr list)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path, key);
	return(node->GetAllData(list));
}


/******************************************************
	Tum[hɊւ鏈
*******************************************************/
/*!
	m[h폜
*/
void CWorkspace::DeleteNode(LPCSTR _path)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	//	Ō::폜
	path = path.Mid(0,path.GetLength()-2);


	if(path.IsEmpty())
	{
		//	[g폜H
		m_root.Clear();
	}
	else
	{
		CString key;
		CWorkspaceNode * node = GetSubNode(path,key);
		node->DeleteNode(key);
	}
}


/*!
	Tum[h𓾂
*/
int CWorkspace::GetSubNodeCount(LPCSTR _path)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path, key);

	return(node->GetSubNodeCount());
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspace::GetAllSubNode(LPCSTR _path,IAPIPassStringArrayPtr list)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	CString path = ToNodePath(_path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetAllSubNode(list));

}



/*********************************************************
	̑̏
**********************************************************/
/*!
 	m[hpXɕύX
 
 	@param path	pX
 	@return		pX
*/
CString CWorkspace::ToNodePath(CString path)
{
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	return path;
}

/*!
	Tum[h̃|C^擾
*/
CWorkspaceNode *CWorkspace::GetSubNode(CString path, CString &key)
{
	SCOPE_LOCK();

	CWorkspaceNode *node = m_root.GetSubNode(path, key);
	ASSERT(node != NULL);

	return(node);
}


/*!
	Rs[
*/
void CWorkspace::InternalCopy(CWorkspaceNode *dest, CString srcPath)
{
	CString key;
	CWorkspaceNode * sNode = GetSubNode(srcPath,key);

	//	OȊORs[
	CString	name = dest->GetNodeName();
	*dest = *sNode;
	dest->SetNodeName(name);
}


/*!
	Rs[
*/
void CWorkspace::ExternalCopy(IWorkspace *src, CString srcPath, CString destPath)
{
	//
	//	SL[ƃf[^Rs[
	//
	CStringArray		keys, datas;
	CISArrayToCSArray	_keys(keys), _datas(datas);

	//	L[擾
	src->GetAllKey(srcPath, &_keys);

	//	f[^擾
	src->GetAllData(srcPath, &_datas);

	//	Ώۃm[hփL[Rs[
	CString key;
	CWorkspaceNode * dNode = GetSubNode(destPath, key);
	dNode->ClearAndSetKeys(keys, datas);


	//
	//	Tum[hRs[
	//
	CStringArray		nodes;
	CISArrayToCSArray	_nodes(nodes);

	//	m[hXg擾
	src->GetAllSubNode(srcPath, &_nodes);

	//	Tum[h̃Rs[
	for(int i=0;i<nodes.GetCount();i++)
	{
		dNode->AddSubNode(nodes[i]);

		//	ċA
		ExternalCopy(src, srcPath + nodes[i] + "::", destPath + nodes[i] + "::");
	}
}
