/*!
	IUserManager.h
	[U}l[W
*/
#pragma once
#include "InterfaceWrapperMacro.h"
#include "UserInfo.h"

/*!
	IUserManager.h
	[U}l[W
*/
class IUserManager
{
public:
	//!	[U[擾
	virtual int GetUserInfo(LPCSTR userName, IWorkspaceAccessRefPtr serverInfoRef) = 0;

	//!	S[UXg擾
	virtual void GetAllUser(IStringArrayPtr enableUsers, IStringArrayPtr disableUsers, IStringArrayPtr groups) = 0;
};

/*!
	IUserManagerbp
*/
class CIUserManagerWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIUserManagerWrap, IUserManager, 1);

	/*!
		[U[擾

		擾̂́A[Uւ̈ꎞIȃANZX
	*/
	virtual int GetUserInfo(CString userName, CUserInfo &userInfoRef)
	{
		return m_ifPtr->GetUserInfo(userName, userInfoRef.GetIWorkspaceAccessRef());
	}

	/*!
		S[UXg擾
	*/
	virtual void GetAllUser(CStringArray enableUsers, CStringArray disableUsers, CStringArray groups)
	{
		CIStringArrayWrap	_enableUsers(enableUsers);
		CIStringArrayWrap	_disableUsers(disableUsers);
		CIStringArrayWrap	_groups(groups);

		m_ifPtr->GetAllUser(&_enableUsers, &_disableUsers, &_groups);
	}
};
