#pragma once
#include "BasicTypeInterfaces.h"
#include "WorkspaceNodeWalker.h"
#include "WorkspaceKeyPairArray.h"
#include "SimpleArrayTemplate.h"
#include "WorkspaceString.h"

#define	NODE_NAME_LEN	128	//	m[hWobt@
#define	NODE_GROW_SIZE	5	//	TCY


//	錾Ă
class CWorkspaceNode;

/*!
	m[hpv[
*/
class IWorkspaceNodeArrayMemoryPool
{
public:
	//!	L[yApv[擾
	virtual IWorkspaceKeyPairArrayMemoryPool *GetKeyPairArrayMemoryPool()
	{
		return NULL;
	}

	//!	ubNm
	virtual void *AllocMemoryBlock(int blockSize, int count) = 0;

	//!	ubNJ
	virtual void FreeMemoryBlock(void *memPtr) = 0;

	//!	œK`NTCY擾
	int GetChunkSize();
};


/*!
	m[hzNX⏕NX
*/
class CWorkspaceNodeArrayItmeConstructor
{
public:
	//!	RXgN^Ă
	static void ConstructItem(CWorkspaceNode *item, void *userData);

	//!	fXgN^Ă
	static void DestructItem(CWorkspaceNode *item, void *userData);
};


/*!
	m[hz^̐錾
*/
class CWorkspaceNodeArray : public CSimpleArrayTemplate<CWorkspaceNode, CWorkspaceNode&, CWorkspaceNodeArrayItmeConstructor, NODE_GROW_SIZE>
{
public:
	//	RXgN^
	CWorkspaceNodeArray(IWorkspaceNodeArrayMemoryPool *memoryPool)
	{
		SetConstructorsUserData(memoryPool);
	}
};


/*!
	[NXy[X̃m[hێNX
*/
class CWorkspaceNode
{
public:
	CWorkspaceNode(const CWorkspaceNode &othe);
	CWorkspaceNode(IWorkspaceNodeArrayMemoryPool *memoryPool);
	CWorkspaceNode(IWorkspaceNodeArrayMemoryPool *memoryPool, LPCSTR name);
	~CWorkspaceNode(void);

	/*********************************************************
		Ȃ
	**********************************************************/
	//!	CArrayŗp邽߂́ARs[Zq
	void operator=(const CWorkspaceNode &other);

	//!	Sf[^NA
	void Clear(void);

	//!	m[h̐ݒ
	void SetNodeName(LPCSTR name) { m_nodeName = name; };

	//!	m[h̎擾
	LPCSTR GetNodeName() const { return(m_nodeName); }; 


	/*********************************************************
		KeyɊւ鏈
	**********************************************************/
	//!	f[^̐ݒ
	void SetKeyData(LPCSTR key, LPCSTR data,int noCase);

	//!	f[^̎擾
	LPCSTR GetKeyData(LPCSTR key, LPCSTR defaultData, int noCase);

	//!	f[^̍폜
	void DeleteKey(LPCSTR key);

	//!	L[擾
	int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	int GetAllKeyPair(IStringArrayPtr keys, IStringArrayPtr datas);


	//!	L[
	int FindKeyData(LPCSTR sData, int noCase = FALSE, int pathCompare = FALSE);

	//!	L[܂Ƃ߂Đݒ
	void ClearAndSetKeys(CStringArray &keys, CStringArray &datas);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[hw܂߂Č(Βǉ)
	CWorkspaceNode *GetSubNode(CWorkspaceNodeWalker &path, CWorkspaceString255 &key);

	//!	m[h폜
	void DeleteNode(LPCSTR name);

	//!	Tum[h𓾂
	int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	int GetAllSubNode(IStringArrayPtr list);


	/******************************************************
		o͂Ɋւ鏈
	*******************************************************/
	//!	Tum[h𖼑O擾E쐬
	CWorkspaceNode *GetSubNodeByName(LPCSTR name, int errorIfExist = FALSE);

	//!	Tum[hCfbNXŎ擾
	CWorkspaceNode *GetSubNodeByIndex(int index);

	//!	L[CfbNXŎ擾
	CWorkspaceKeyPair *GetKeyByIndex(int index);

protected:
	/******************************************************
		KeyɊւ鏈
	*******************************************************/
	//!	Key̌
	int FindKeyIndex(LPCSTR key,int noCase);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[h
	int FindSubNodeIndex(LPCSTR name);

	/******************************************************
		v[֌W̏
	*******************************************************/
	//!	IWorkspaceKeyPairArrayMemoryPool擾
	IWorkspaceKeyPairArrayMemoryPool *GetPairArrayMemoryPool(IWorkspaceNodeArrayMemoryPool *basePool);

protected:
	//!	̃m[h̎f[^
	CWorkspaceKeyPairArray			m_keyData;

	//!	Tum[g
	CWorkspaceNodeArray				m_subNode;

	//!	̃m[h̖O
	CWorkspaceString<NODE_NAME_LEN>	m_nodeName;

	//!	v[
	IWorkspaceNodeArrayMemoryPool	*m_memoryPool;
};

