#include "StdAfx.h"
#include "WorkspaceXMLReader.h"

#define	ATTR_KEY	0
#define	ATTR_DATA	1

CWorkspaceXMLReader::CWorkspaceXMLReader(void)
{
}

CWorkspaceXMLReader::~CWorkspaceXMLReader(void)
{
}

void CWorkspaceXMLReader::LoadFromFile(CWorkspaceNode *root, CString path, CString workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	//	
	StartScan(LoadXmlFile(path));

	//	ŏI`FbN
	if(m_depth.GetCount())
		throw CXMLTextParserException(_T("SubnodeĂ܂"), 0);
}

/*!
	XMLǂݍ(throw CXMLTextParserException)
*/
void CWorkspaceXMLReader::FromString(CWorkspaceNode *root, CString str, CString workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	//	
	StartScan(str);

	//	ŏI`FbN
	if(m_depth.GetCount())
		throw CXMLTextParserException(_T("SubnodeĂ܂"), 0);
}

/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CWorkspaceXMLReader::OnStartTag(LPCSTR tag, LPCSTR *atts)
{
	//	`FbN
	if(m_inKeyLeaf)
		throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), 0);

	//	^O
	if(_tcscmp(tag, _T("CWorkspaceClass")) == 0 || _tcscmp(tag, _T("CConfigClass")) == 0)	//	Jn
	{
		//	Jnʒu`FbN
		if(m_depth.GetCount() != 0)
			throw CXMLTextParserException(_T("CWorkspaceClass^Oł"), 0);

		//	^Cv`FbN
		if(GetAttrCount(atts) != 2 || _tcscmp(atts[ATTR_KEY], _T("type")) != 0)
			throw CXMLTextParserException(_T("CWorkspaceClass^Oł"), 0);

		//	NX`FbN
		if(_tcscmp(atts[ATTR_DATA], m_workspaceClassType) != 0)
			throw CXMLTextParserException(_T("[NXy[XقȂ܂A[hł܂"), 0);
	}
	else if(_tcscmp(tag, _T("Subnode")) == 0 || _tcscmp(tag, _T("Node")) == 0)	//	m[h
	{
		//	^Cv`FbN
		if(GetAttrCount(atts) != 2 || _tcscmp(atts[ATTR_KEY], _T("name")) != 0)
			throw CXMLTextParserException(_T("Subnode^Oł"), 0);

		//	ŏʁH
		if(m_depth.GetCount() == 0)
		{
			//	NX`FbN
			if(_tcscmp(atts[ATTR_DATA], m_workspaceClassType) != 0)
				throw CXMLTextParserException(_T("[NXy[XقȂ܂A[hł܂"), 0);
			else
				m_depth.AddHead(m_curNode);
		}
		else
		{
			//	ǉ
			m_curNode = m_curNode->GetSubNodeByName(atts[ATTR_DATA], TRUE); 
			if(m_curNode == NULL)
				throw CXMLTextParserException(_T("Subnode݂܂"), 0);
			m_depth.AddHead(m_curNode);
		}
	}
	else if(_tcscmp(tag, _T("Key")) == 0 || _tcscmp(tag, _T("Leaf")) == 0)	//	L[
	{
		//	`FbN
		if(m_depth.GetCount() == 0 || GetAttrCount(atts) != 2 || 
			(_tcscmp(atts[ATTR_KEY], _T("name")) != 0 && _tcscmp(atts[ATTR_KEY], _T("key")) != 0))
			throw CXMLTextParserException(_T("Key^Oł"), 0);

		m_inKeyLeaf = 1;
		m_onDataCount = 0;
		m_keyName = atts[ATTR_DATA];
		m_keyData.Empty();
	}
	else	//	G[
	{
		throw CXMLTextParserException(_T("ȃ^Oł"), 0);
	}
}

/*!
	I^O
*/
void CWorkspaceXMLReader::OnEndTag(LPCSTR tag)
{
	//	^O
	if(_tcscmp(tag, _T("CWorkspaceClass")) == 0 || _tcscmp(tag, _T("CConfigClass")) == 0)	//	Jn
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), 0);
	}
	else if(_tcscmp(tag, _T("Subnode")) == 0 || _tcscmp(tag, _T("Node")) == 0)	//	m[h
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), 0);

		//	m[h[`FbN
		if(m_depth.GetCount() <= 0)
			throw CXMLTextParserException(_T("Subnode^ȎΉُł"), 0);

		m_depth.RemoveHead();

		//	ŏʁH
		if(m_depth.GetCount() != 0)
			m_curNode = m_depth.GetHead();
		else
			m_curNode = NULL;
	}
	else if(_tcscmp(tag, _T("Key")) == 0 || _tcscmp(tag, _T("Leaf")) == 0)	//	L[
	{
		//	`FbN
		if(!m_inKeyLeaf)
			throw CXMLTextParserException(_T("ȏI^Oł"), 0);

		//	KvȂĐݒ
		if(m_onDataCount >= 2)
			m_curNode->SetKeyData(m_keyName, m_keyData, FALSE);
		m_onDataCount = 0;
		m_inKeyLeaf = 0;
	}
	else	//	G[
	{
		throw CXMLTextParserException(_T("ȃ^Oł"), 0);
	}
}

/*!
	f[^
*/
void CWorkspaceXMLReader::OnData(const CHAR *data, int len)
{
	if(m_inKeyLeaf)
	{
		//	ēxĂяoH
		if(m_onDataCount == 0)
			m_curNode->SetKeyData(m_keyName, m_sjis.ToCString(data, len), FALSE);
		else if(m_onDataCount == 1)
		{
			m_keyData = m_curNode->GetKeyData(m_keyName, "", FALSE);
			m_keyData += m_sjis.ToCString(data, len);
		}
		else
			m_keyData += m_sjis.ToCString(data, len);

		//	ĂяoJEg
		m_onDataCount++;
	}
}

