/*!
	ClientConnectionQueue.cpp

	NCAgVKڑpL[
*/
#include "StdAfx.h"
#include "ClientConnectionQueue.h"


///////////////////////////////////////////////////////////////////
//	RXgN^
///////////////////////////////////////////////////////////////////
CClientConnectionQueue::CClientConnectionQueue(void)
{
	m_semaphore.Create(0, 100000);
	SetMaxQueue(100);
}

CClientConnectionQueue::~CClientConnectionQueue(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////
//	C^[tF[X
///////////////////////////////////////////////////////////////////
/*!
	I
*/
void CClientConnectionQueue::Stop()
{
	CRITICAL_SECTION_SCOPE();

	//	폜
	while(m_queue.GetCount())
		m_queue.RemoveHead().Delete();
}

/*!
	ǉ
*/
int CClientConnectionQueue::AddNewConnection(IClientConnectionPtr newConnection)
{
	CRITICAL_SECTION_SCOPE();

	//	ő吔ȉH
	if(m_queue.GetCount() >= m_maxQueue)
		return(-1);

	//	ǉ
	m_queue.AddTail(IClientConnectionAutoPtr(newConnection));
	::ReleaseSemaphore(m_semaphore, 1, NULL);

	return(0);
}

/*!
	擾
*/
IClientConnectionPtr CClientConnectionQueue::GetNewConnection()
{
	CRITICAL_SECTION_SCOPE();

	//	́H
	if(m_queue.GetCount() <= 0)
		return(IClientConnectionPtr());

	//	擾
	return(m_queue.RemoveHead().Detach());
}

/*!
	ő吔ݒ
*/
void CClientConnectionQueue::SetMaxQueue(int max)
{
	m_maxQueue = max;
	m_queue.SetMinQueueSize(m_maxQueue);
}

/*!
	݂̕ێ擾
*/
int CClientConnectionQueue::GetCurrentQueueCount()
{
	CRITICAL_SECTION_SCOPE();

	return(m_queue.GetCount());
}
