#include "StdAfx.h"
#include "CnotextManager.h"
#include "DateTools.h"

CCnotextManager::CCnotextManager(void)
{
	m_context = m_contextRoot.GetAccess(_U8("Context::Context"));
	m_contextLog = m_contextRoot.GetAccess(_U8("Context::ContextLog"));

	m_maxConetextLog = 0;
	m_contextID = 0;
}

CCnotextManager::~CCnotextManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
//!	
void CCnotextManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	ݒ擾
	m_setting = serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	ő働O擾
	m_maxConetextLog = m_setting.GetMaxContextLogCount();
}

/*!
	~
*/
void CCnotextManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	IConetextManager
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ReLXg̃Rs[
*/
void CCnotextManager::DuplicateContext(CWorkspace &copyTo, CUTF8String copyRootPath)
{
	WORKSPACE_LOCK(m_context);

	//	Rs[
	copyTo.Duplicate(m_contextRoot, _U8(""), copyRootPath);
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	IConetextGene
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ReLXg̎擾
*/
CContext CCnotextManager::GetNewContext(LONG connectionID)
{
	//	O
	CUTF8String	contextName;
	contextName.Format(_U8("Request_%08x"), m_contextID.IncCounter());

	//	ReLXg
	CContext	context = m_context.GetAccess(contextName);

	//	ݒ
	context.SetName(contextName);			//	O
	GetDate(context.GetStartTime());		//	
	context.SetStatus(_U16("ł..."));	//	
	context.SetConnectionID(connectionID);	//	ڑID

	return(context);
}

/*!
	ReLXg̔j
*/
void CCnotextManager::ReleaseContext(CContext context)
{
	//	O擾
	CUTF8String name = context.GetName();
	ASSERT(!name.IsEmpty());

	//	IԐݒ
	GetDate(context.GetEndTime());		//	

	//	Oړ
	if(m_maxConetextLog > 0)
	{
		//	ORs[
		m_contextLog.GetAccess(name).Copy(context);

		//	ꎞIɃbN
		WORKSPACE_LOCK(m_context);

		//	O̒
		if(m_contextLog.GetSubNodeCount() > m_maxConetextLog)
		{
			CUTF8StringArray	nodes;
			m_contextLog.GetAllSubNode(nodes);
			m_contextLog.DeleteNode(nodes[0]);
		}
	}

	//	폜
	m_context.DeleteNode(name);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
 *	t擾
 */
void CCnotextManager::GetDate(CContextDate date)
{
	//	NA
	date.Clear();

	//	
	CTime_t	time=CTime_t::GetCurrentTime();
	date.SetDate(time.Format(_U8("%Y/%m/%d")));
	date.SetTime(time.Format(_U8("%H:%M:%S")));
	date.SetGMT(CDateTools::GetGMTString(time));
	date.SetTIME_T(time.GetTime_t());
}

