#include "StdAfx.h"
#include "ConnectionThreadManager.h"
#include "ServerException.h"

#define	CLASS_NAME	_U8("ConnectionThreadManager")

CConnectionThreadManager::CConnectionThreadManager(void)
{
}

CConnectionThreadManager::~CConnectionThreadManager(void)
{
	Stop();
}



/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CConnectionThreadManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;

	//	Rs[A
	m_serverTool = serverTool;
	m_endThreadCount = 0;
	m_connectionID = 0;


	//	ݒ擾
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	ݒ菉
	int maxConnect = m_setting.GetMaxConnect();
	m_maxThreads = maxConnect;

	//	L[
	m_queue.SetMaxQueue(maxConnect); //	őڑݒ肷
	m_queue.Start();

	//	I[o[[h
	m_overload.Start(m_serverTool.GetIServerTool(), maxConnect, m_setting.GetOverloadModeKeepTime());

	//	ReLXg
	m_context.Start(m_serverTool.GetIServerTool());

	//	XbhN
	if(StartThread())
		throw CServerStartErrorException(CLASS_NAME, _U16("Xbh̋NɎs܂"));

	//	
	m_init = TRUE;

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO, _U16("ڑXbh}l[WN܂"));
}

/*!
	~
*/
void CConnectionThreadManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	Xbh~
	EndThread();

	//	SXbh폜
	m_threads.RemoveAll();

	//	ReLXg~
	m_context.Stop();

	//	I[o[[h}l[W~
	m_overload.Stop();

	//	҂󂯃L[~
	m_queue.Stop();

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO, _U16("ڑXbh}l[W~܂"));
}


/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CConnectionThreadManager::ThreadMain()
{
	//	ڑ[v
	while(!GetBreak())
	{
		//	
		if(InMaxThreads())
		{
			//	Ƒ҂
			WaitForSomeObjects(100, GetBreakEvent());
		}
		else
		{
			//	ڑ҂
			if(WaitForSomeObjects(500, m_queue.GetSemaphore(), GetBreakEvent()) == 1)
				CreateNewThread(m_queue.GetNewConnection());
		}

		//	GC
		DeleteEndThreads();

		//	T[oאݒ
		m_overload.UpdateServerload(GetThreadCount(), m_queue.GetCurrentQueueCount());
	}
}


/*!
	Vڑǉ
*/
void CConnectionThreadManager::CreateNewThread(IClientConnectionAutoPtr connection)
{
	CRITICAL_SECTION_SCOPE();

	//	H
	if(connection.IsEmpty())
		return;

	try
	{
		//	
		CConnectionThread *thread = new CConnectionThread();
		if(thread->Start(	m_serverTool.GetIServerTool(),
							this,
							m_context.GetIConetextGene(),
							connection,
							m_connectionID++))
			m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_ERROR, _U16("Xbh̋NɎs܂"));

		//	ǉ
		m_threads.AddTail(CConnectionThreadAutoPtr(thread));
	}
	catch(CBadAllocException &err)
	{
		//	gpȂ
		UNREFERENCED_PARAMETER(err);

		//	
		m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_ERROR, _U16("s܂"));

		//	ҋ@
		Sleep(1000);
	}
}

/*!
	ڑЕt

	EndConnectionĂ΂ꂽ_ł́A܂XbhIĂȂ߁A|[OKv
*/
void CConnectionThreadManager::DeleteEndThreads()
{
	CRITICAL_SECTION_SCOPE();

	//	sv
	if(m_endThreadCount == 0)
		return;

	//	č폜
	for(int i=m_threads.GetCount()-1;i>=0;i--)
	{
		//	IH
		if(!m_threads[i]->IsRunning())
			m_threads.RemoveAt(i);
	}

	//	0
	m_endThreadCount = 0;
}

/*!
	őڑɓBH
*/
int CConnectionThreadManager::InMaxThreads()
{
	CRITICAL_SECTION_SCOPE();

	//	őXbhɓBH
	if(m_threads.GetCount() >= m_maxThreads)
		return(TRUE);
	return(FALSE);
}

/*!
	ڑ擾
*/
int CConnectionThreadManager::GetThreadCount()
{
	CRITICAL_SECTION_SCOPE();

	return(m_threads.GetCount());
}

/////////////////////////////////////////////////////////////////////////////////////
//	IConnectionThreadParent
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XbhI
*/
void CConnectionThreadManager::EndConnection(CConnectionThread *connectionPtr)
{
	CRITICAL_SECTION_SCOPE();

	m_endThreadCount++;
}

/*!
	I[o[[h
*/
int CConnectionThreadManager::InOverloadMode()
{
	return m_overload.InOverloadMode();
}

