#pragma once
#include "IServerTool.h"
#include "IConnectionThreadStatus.h"
#include "InterfaceAutoPtr.h"



/*!
	NCAgʐMC^tF[X

	throw CConnectionErrorException
*/
class IClientConnection
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void AttacheToThread(IServerToolPtr serverTool, IConnectionThreadStatusPtr threadStatus) = 0;

	//!	~
	virtual void Close() = 0;

	//!	폜
	virtual void Delete() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NCAg̎擾
	virtual void GetClientInfo(IWorkspaceAccessPtr clientInfo) = 0;

	//!	̐ڑ҂
	virtual int WaitNextRequest(int waitTime) = 0;

	//!	ڑ擾(IConnectionThreadStatusPtr::IsConnecting̎gp)
	virtual int IsConnecting() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	M
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	1:wb_M(throw)
	virtual void RecvRequestHeader(IStringPtr requestHeader) = 0;

	//!	2:{fBM(throw)
	virtual int RecvRequestBody(IBinaryDataPtr body, int leftSize) = 0;

	//!	3:M
	virtual void EndRecvRequest() = 0;


	//!	4:wb_𑗐M(throw)
	virtual void SendResponseHeader(IStringPtr responseHeader) = 0;

	//!	5:{fB𑗐M(throw)
	virtual void SendResponseBody(IBinaryDataPtr body) = 0;

	//!	6:M
	virtual void EndSendResponse() = 0;
};

//!	|C^^
typedef IClientConnection* IClientConnectionPtr;

//!	|C^^
typedef CInterfaceAutoPtr<IClientConnection> IClientConnectionAutoPtr;

//!	|C^^(ꎞp)
typedef CInterfaceAutoPtrTempCopy<IClientConnection> IClientConnectionTempPtr;
