/*!
	T[oc[C^tF[X
*/
#pragma once
#include "types/WorkspaceTypes.h"
#include "IManagerInterface.h"

/*!
	O^Cv
*/
enum
{
	//!	\̂݁At@Cɂ͋L^Ȃ
	SYSTEM_LOG_INFO				= 100,

	//!	t@CɋL^郍O
	SYSTEM_LOG_INFO_LOG			= 0,

	//!	x
	SYSTEM_LOG_WARNING			= -100,

	//!	G[
	SYSTEM_LOG_ERROR			= -200,

	//!	vIG[
	SYSTEM_LOG_FATAL_ERROR		= -300,
};

/*!
	bZ[W^Cv
*/
enum
{
	//!	
	SYSTEM_MESSAGE_OFF			= 0,

	//!	
	SYSTEM_MESSAGE_INFO			= 100,

	//!	
	SYSTEM_MESSAGE_WARNING		= 200,

	//!	ԕ
	SYSTEM_MESSAGE_ERROR		= 300,
};


/*!
	ݒ薼
*/
#define	MANAGER_SETTING		_U8("ManagerSetting")
#define	FILTER_SETTING		_U8("FilterSetting")
#define	RESPONSE_SETTING	_U8("ResponseSetting")
#define	SERVER_STATUS		_U8("ServerStatus")
#define	SERVER_INFO			_U8("ServerInfo")


/*!
	T[opc[
*/
class IServerTool
{
public:
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(LPCU8STR callerName, int logType, LPCU8STR logString) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatus(LPCU8STR statusName, LPCU8STR status, LPCU8STR statusInfo, LPCU8STR statusType) = 0;

	//!	T[obZ[Wʒm
	virtual void NotifyServerMessage(LPCU8STR messageID, LPCU8STR message, int messageType, int autoOffTimeSec = -1) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	[NXy[Xւ̃ANZX擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCU8STR type, LPCU8STR section) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[XǗ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCU8STR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface = NULL) = 0;

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCU8STR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface = NULL) = 0;

	//!	C^tF[X擾
	virtual void *GetManagerInterface(LPCU8STR interfaceName, int ifVersion) = 0;
};
//!	|C^^
typedef IServerTool* IServerToolPtr;
