#pragma once

//	X^eBbNCuw
#define	XML_STATIC

#include "expat\expat.h"
#include "TypedBuffer.h"

//	obt@ݒ
#define	EXPAT_SJIS_STRING_BUF_LEN		256
#define	EXPAT_SJIS_STRING_BUF_COUNT		10
#define	EXPAT_UTF16_STRING_BUF_COUNT	1024

/*!
	O
*/
class CXMLTextParserException
{
public:
	CXMLTextParserException() {};
	CXMLTextParserException(CString error, int point)
	{
		m_error = error;
		m_point = point;
	};

	CString	m_error;
	int		m_point;
};


/*!
	UTF8->SJISRo[^

	ϊKvȏꍇ̂ݕϊAobt@IɊmۂ
	֐ICleanupĂ
*/
class CExpatXmlParserUTF8Convert
{
public:
	CExpatXmlParserUTF8Convert();
	virtual ~CExpatXmlParserUTF8Convert();

	//!	擾
	LPCSTR ConvertToSJIS(LPCSTR utf8)
	{
		int	len = -1;
		return(ConvertToSJIS(utf8, len));
	}

	//!	擾
	LPCSTR ConvertToSJIS(LPCSTR utf8, int &len);

	//!	|
	void Cleanup();

	//!	C
	LPCSTR ToCString(const CHAR *buf, int len);

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	/////////////////////////////////////////////////////////////////////////////////////
	//!	ASCIIȊO܂ނ`FbN
	int CheckUTF8(LPCSTR str, int len=-1);

	//!	m
	LPSTR AllocString(int len);

	//!	gobt@m
	LPSTR AllocExtString(int len);

	//!	UTF16obt@擾
	wchar_t *AllocUTF16Buf(int count);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	SJISobt@
	CHAR	m_sjisBuf[EXPAT_SJIS_STRING_BUF_COUNT][EXPAT_SJIS_STRING_BUF_LEN];

	//!	obt@gp
	int		m_sjisBufUsing;

	//!	KiOobt@
	CTypedPtrArray<CPtrArray, char *>	m_extSjisBuf;

	//!	UTF16pobt@
	wchar_t	m_utf16Buf[EXPAT_UTF16_STRING_BUF_COUNT];

	//!	UTF16gobt@
	CTypedBuffer<wchar_t>	m_extUtf16Buf;

};

/*!
	XMLp[T[
*/
class CExpatXmlParser
{
public:
	CExpatXmlParser(void);
	virtual ~CExpatXmlParser(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Jn
	/////////////////////////////////////////////////////////////////////////////////////
	//!	XL
	void StartScan(CStringA xmlUtf8);

	//!	t@C擾
	CString LoadXmlFile(CString path);

	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Jn^O
	virtual void OnStartTag(LPCSTR tag, LPCSTR *atts) {/* TRACE(_T("StartTag : %s\n"), tag); */};

	//!	I^O
	virtual void OnEndTag(LPCSTR tag) {/* TRACE(_T("EndTag : %s\n"), tag); */};

	//!	f[^
	virtual void OnData(const CHAR *data, int len) {/* TRACE(_T("Data : %s\n"), data); */};

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	/////////////////////////////////////////////////////////////////////////////////////
	//!	
	int Init();

	//!	I
	void Close();

	//!	ASCIIȊO܂ނ`FbN
	int CheckUTF8(const XML_Char *str, int len=-1);

	//!	Attr`FbN
	int GetAttrCount(LPCSTR *atts);

private:
	/////////////////////////////////////////////////////////////////////////////////////
	//	R[obN
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Jn^O
	static void StartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts);

	//!	I^O
	static void EndElementHandler(void *userData, const XML_Char *name);
	
	//!	f[^
	static void CharacterDataHandler(void *userData, const XML_Char *s, int len);

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	p[T[
	XML_Parser	m_parser;

	//!	tO
	int			m_init;

	//!	SJISRo[^
	CExpatXmlParserUTF8Convert	m_sjis;
};
