#pragma once
#include "workspaceaccess.h"
#include "WorkspaceListAccess.h"

/*!
	VXeO
*/
class CServerSystemLog :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerSystemLog);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Ăяo
	DEFINE_PROPERTY_METHOD_STR(Caller, "Caller", "");

	//!	Xe[^X
	DEFINE_PROPERTY_METHOD_STR(LogString, "LogString", "");

	//!	
	DEFINE_PROPERTY_METHOD_STR(Time, "Time", "");

	//!	R[h
	DEFINE_PROPERTY_METHOD_INT(LogType, "LogType", 0);
};
typedef CWorkspaceTypedListAccess<CServerSystemLog, CWTLAName<'L', 'o', 'g'>> CServerSystemLogList;


/*!
	Xe[^X
*/
class CServerStatusEntry :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerStatusEntry);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^X
	DEFINE_PROPERTY_METHOD_STR(StatusName, "StatusName", "");

	//!	
	DEFINE_PROPERTY_METHOD_STR(Status, "Status", "");

	//!	
	DEFINE_PROPERTY_METHOD_STR(StatusInfo, "StatusInfo", "");

	//!	`
	DEFINE_PROPERTY_METHOD_STR(StatusType, "StatusType", "Integer");

};


/*!
	ʒm
*/
class CServerNotifyEntry :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerNotifyEntry);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ID
	DEFINE_PROPERTY_METHOD_STR(MessageID, "MessageID", "");

	//!	bZ[W
	DEFINE_PROPERTY_METHOD_STR(Message, "Message", "");

	//!	^Cv
	DEFINE_PROPERTY_METHOD_INT(MessageType, "MessageType", 0);

	//!	
	DEFINE_PROPERTY_METHOD_STR(Time, "Time", "");

	//!	
	DEFINE_PROPERTY_METHOD_INT(AutoOffTimeSec, "AutoOffTimeSec", -1);

};


class CServerStatus :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerStatus);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃANZX
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^XO擾
	CServerSystemLogList GetSystemLog() { return GetAccess("SystemLog"); };


	//!	T[oXe[^X擾
	CServerStatusEntry GetServerStatusEntry(CString statusName) { return GetAccess("Status::" + statusName); };

	//!	T[oXe[^X擾
	int GetServerStatusCount() { return GetAccess("Status").GetSubNodeCount(); }


	//!	ʒm擾
	CServerNotifyEntry GetServerNotifyEntry(CString messageID) { return GetAccess("Notify::" + messageID); };

	//!	ʒm擾
	int GetServerNotifyCount() { return GetAccess("Notify").GetSubNodeCount(); }
};
