/*!
	CServerStatusManager

	T[oXe[^X}l[W
	eW[̏o͂Xe[^Xۊǂ
*/

#pragma once
#include "ServerStatus.h"
#include "IServerToolWrap.h"
#include "SyncObject.h"
#include "SystemLogManager.h"

class CServerStatusManager
{
public:
	CServerStatusManager(void);
	virtual ~CServerStatusManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

	//!	Oo
	void WriteSystemLog(CUTF8String callerName, int logType, CUTF8String logString);

	//!	T[oXe[^X̕ύX
	void SetServerStatus(CUTF8String statusName, CUTF8String status, CUTF8String statusInfo, CUTF8String statusType);

	//!	T[obZ[Wʒm
	void NotifyServerMessage(CUTF8String messageID, CUTF8String message, int messageType, int autoOffTimeSec = -1);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^X擾
	void DuplicateStatus(CWorkspace &status);

	//!	Xe[^X擾
	CServerStatus GetStatus()
	{
		return m_serverStatus;
	}


	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	void SetServerStatusInt(CUTF8String statusName, int status, CUTF8String statusInfo = _U8(""), CUTF8String statusType = _U8("Interger"))
	{
		//	
		TCHAR	str[80] = _U16("");
		_itow_s(status, str, 80, 10);

		//	ݒ
		SetServerStatus(statusName, str, statusInfo, statusType);
	}

	//!	T[oXe[^X̕ύX
	void SetServerStatusStr(CUTF8String statusName, CUTF8String status, CUTF8String statusInfo = _U8(""), CUTF8String statusType = _U8("String"))
	{
		SetServerStatus(statusName, status, statusInfo, statusType);
	}

protected:
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^Xێ
	CWorkspace				m_statusRoot;

	//!	T[oXe[^X
	CServerStatus			m_serverStatus;

	//!	tO
	CInterlockCounter		m_init;

	//!	VXeO
	CSystemLogManager		m_systemLog;
};
