/*!
	BufferdSocket.h

	\Pbg{NX
*/
#pragma once

#include <Winsock2.h>
#include "FifoBuffer.h"
#include "IPAddress.h"
#include "SyncObject.h"
#include "OverlappedSocket.h"


/*!
	\Pbg{NX

	ʐḾAWaitNextEventōsB
	WaitNextEventɂubN͂́AAbort()AGetBreakEvent()Ŏ擾CxgZbgA
	SetExBreakEvent()Őݒ肵CxgZbgŒf
*/
class CBufferdSocket
{
public:
	//////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	//////////////////////////////////////////////////////////////////////////////////
	CBufferdSocket(void);
	virtual ~CBufferdSocket(void);

	//////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	//////////////////////////////////////////////////////////////////////////////////
	//!	gpJn
	virtual int AttachSocket(SOCKET sock);

	//!	
	virtual void Close();

	//////////////////////////////////////////////////////////////////////////////////
	//	fC^[tF[X
	//////////////////////////////////////////////////////////////////////////////////
	//!	gfCxgݒ
	void SetExBreakEvent(HANDLE exBreakEvent = NULL);

public:
	//////////////////////////////////////////////////////////////////////////////////
	//	ʐMXe[^X
	//////////////////////////////////////////////////////////////////////////////////
	//!	ؒfĂ邩擾
	virtual int IsDisconnect();

	//////////////////////////////////////////////////////////////////////////////////
	//	ڑ
	//////////////////////////////////////////////////////////////////////////////////
	//!	̃AhX擾
	CIPAddress GetAddres();

	//!	̃AhX擾
	CIPAddress GetPeerAddres();

	//!	̃|[g擾	
	int GetPort();

	//!	̃|[g擾
	int GetPeerPort();


	//////////////////////////////////////////////////////////////////////////////////
	//	G[
	//////////////////////////////////////////////////////////////////////////////////
	//!	G[擾
	int GetLastError() { return m_lastError; };

	//!	G[𕶎Ŏ擾
	CUTF8String GetLastErrorString();

	//!	G[R[h當擾
	virtual CUTF8String GetErrorString(int errorCode);

	//!	G[R[h
	enum
	{
		CBS_NO_ERROR = 0,
		CBS_ERROR_TIMEOUT	= 1000,
		CBS_ERROR_CLOSE		= 1100,
		CBS_ERROR_BREAK		= 1101,
		CBS_ERROR_OTHER		= 1200,
	}CBS_ERROR_CODE;


protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	obt@ANZX
	//////////////////////////////////////////////////////////////////////////////////
	//!	M
	int WriteBuf(const char *data, int len);

	//!	M
	int ReadBuf(char *data,int len);

	//!	obt@ȂM
	int PeekBuf(char *data,int len);

	//!	Mobt@gpʂ擾
	int GetSendInBuf() { return m_sendBuf.GetInBuf(); };

	//!	Mobt@̋󂫂擾
	int GetSendFreeBuf() { return m_sendBuf.GetFreeBuf(); };

	//! Mobt@gpʂ擾
	int GetRecvInBuf() { return m_recvBuf.GetInBuf(); };

	//! Mobt@̋󂫎擾
	int GetRecvFreeBuf() { return m_recvBuf.GetFreeBuf(); };

	//!	obt@TCY擾
	int GetSendRecvBufSize();

	//////////////////////////////////////////////////////////////////////////////////
	//	ʐM
	//////////////////////////////////////////////////////////////////////////////////
	//!	obt@𑗐M(ubLO)
	virtual int BlockingSend(int timeOut);

	//! obt@֎M(ubLO)
	virtual int BlockingRecv(int timeOut);

	//!	Ă邩`FbN
	virtual int CheckCloseEvent();

	//////////////////////////////////////////////////////////////////////////////////
	//	G[
	//////////////////////////////////////////////////////////////////////////////////
	//!	G[ŕ
	virtual void CloseError(int code, CUTF8String debugInfo);

	//!	G[NA
	virtual void ClearError() { m_lastError = 0; }
	

protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////
	//!	\Pbg
	COverlappedSocket	m_socket;

	//!	Cxg
	CSyncEvent			m_closeEvent;

	//!	OfCxg
	HANDLE				m_exBreakEvent;

	//!	Mf[^obt@
	CFifoBuffer			m_recvBuf;

	//!	Mf[^
	CFifoBuffer			m_sendBuf;

	//!	G[R[h
	int					m_lastError;

private:
	CBufferdSocket(const CBufferdSocket & other);	//	gp֎~
	void operator=(const CBufferdSocket & other);	//	gp֎~
};

