#pragma once
#include <time.h>

//!	ő啶
#define	MAX_TIME_FORMAT_LEN	256

/*!
	time_t bp
*/
class CTime_t
{
public:
	/////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////
	//!	擾
	static CTime_t GetCurrentTime()
	{
		return(CTime_t(::_time64( NULL )));
	}

	//!	m[}RXgN^
	CTime_t(void)
	{
		m_time = 0;
	}

	//!	Rs[RXgN^
	CTime_t(const CTime_t &time)
	{
		m_time = time.m_time;
	}

	//!	time_tRXgN^
	CTime_t(const __time64_t time)
	{
		m_time = time;
	}

	//!	Svfw
	CTime_t(int nYear, int nMonth, int nDay, int nHour, int nMin, int nSec)
	{
		SetTime(nYear, nMonth, nDay, nHour, nMin, nSec);
	}

	//!	SYSTEMTIMERXgN^
	CTime_t(const SYSTEMTIME& st)
	{
		*this = st;
	}

	//!	FILETIMERXgN^
	CTime_t(const FILETIME& ft)
	{
		*this = ft;
	}

	/////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////
	//!	time_t
	CTime_t& operator=(const CTime_t &time)
	{
		m_time = time.m_time;
	}

	//!	CTime_t
	CTime_t& operator=(const __time64_t time)
	{
		m_time = time;
	}

	//!	SYSTEMTIME
	CTime_t& operator=(const SYSTEMTIME& sysTime)
	{
		if(sysTime.wYear < 1900)
		{
			*this = (__time64_t)0;
		}
		else
		{
			CTime_t timeT(
				(int)sysTime.wYear, (int)sysTime.wMonth, (int)sysTime.wDay,
				(int)sysTime.wHour, (int)sysTime.wMinute, (int)sysTime.wSecond);
			*this = timeT;
		}
		return(*this);
	}

	//!	FILETIME
	CTime_t& operator=(const FILETIME& fileTime)
	{
		// ܂́A[J^C֕ϊ
		FILETIME localTime;
		if(!FileTimeToLocalFileTime(&fileTime, &localTime))
		{
			m_time = 0;
			return(*this);
		}

		// VXe^C
		SYSTEMTIME sysTime;
		if(!FileTimeToSystemTime(&localTime, &sysTime))
		{
			m_time = 0;
			return(*this);
		}

		//	VXe^CoRŕϊ
		*this = sysTime;
		return(*this);
	}

	//!	Ԃw肵ăZbg
	CTime_t& SetTime(int nYear, int nMonth, int nDay, int nHour, int nMin, int nSec)
	{
		ASSERT( nYear >= 1900 );
		ASSERT( nMonth >= 1 && nMonth <= 12 );
		ASSERT( nDay >= 1 && nDay <= 31 );
		ASSERT( nHour >= 0 && nHour <= 23 );
		ASSERT( nMin >= 0 && nMin <= 59 );
		ASSERT( nSec >= 0 && nSec <= 59 );

		struct tm atm;
		atm.tm_sec = nSec;
		atm.tm_min = nMin;
		atm.tm_hour = nHour;
		atm.tm_mday = nDay;
		atm.tm_mon = nMonth - 1;
		atm.tm_year = nYear - 1900;
		atm.tm_isdst = -1;
		m_time = _mktime64(&atm);

		ASSERT( m_time != -1 );
		return(*this);
	}


	/////////////////////////////////////////////////////////////////////
	//	擾
	/////////////////////////////////////////////////////////////////////
	//!	__time64_t擾
	__time64_t GetTime_t()
	{
		return m_time;
	}
	
	/////////////////////////////////////////////////////////////////////
	//	Format
	/////////////////////////////////////////////////////////////////////
	//!	
	CUTF8String Format(CUTF8String format, ...) const
	{
		if(format.IsEmpty())
			return format;

		//	ϊ
		struct tm ptm;
		if(_localtime64_s(&ptm, &m_time))
			return(_U8(""));

		//	o
		utf8_char line[MAX_TIME_FORMAT_LEN] = "";
		strftime((LPSTR)line, MAX_TIME_FORMAT_LEN, (LPCSTR)format.GetString(), &ptm);

		return line;
	}

	//!	
	CUTF8String FormatGMT(CUTF8String format, ...) const
	{
		if(format.IsEmpty())
			return format;

		//	GMT擾
		CTime_t	temp(*this);
		temp.ConvertLocalTimeToGMT();

		//	ϊ
		struct tm ptm;
		if(_localtime64_s(&ptm, &temp.m_time))
			return(_U8(""));

		//	o
		utf8_char line[MAX_TIME_FORMAT_LEN] = "";
		strftime((LPSTR)line, MAX_TIME_FORMAT_LEN, (LPCSTR)format.GetString(), &ptm);

		return line;
	}

	/////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////
	/*!
		[JԂ֕ϊ
	*/
	void ConvertGMTToLocalTime()
	{
		//	^C][擾
		TIME_ZONE_INFORMATION	zoneInfo;
		::GetTimeZoneInformation(&zoneInfo);

		//	^C][ɍ킹ĕϊ
		m_time -= (zoneInfo.Bias * 60);
	}

	/*!
		GMT/UTC֕ϊ
	*/
	void ConvertLocalTimeToGMT()
	{
		//	^C][擾
		TIME_ZONE_INFORMATION	zoneInfo;
		::GetTimeZoneInformation(&zoneInfo);

		//	^C][ɍ킹ĕϊ
		m_time += (zoneInfo.Bias * 60);
	}

protected:
	/////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////
	//!	ێ
	__time64_t	m_time;
};
