/*!
	WorkspaceAccess.h

	CWorkspaceփANZX邽߂̃NXACWorkspaceւ̊{IȃANZX͂̃NXoR
	̃NX́ACWorkspacẽm[hւ̃ANZXێÃm[hȉւ̃ANZX񋟂B
	DLL𒴂ꍇ́AIWorkspaceAccessIWorkspaceAccessRefgpAm[hpXIWorkspace󂯓n
	ݒȂǁAvpeB܂Ăꍇ́Apăev[gƂȂNX쐬łB
*/
#pragma once
#include "types/WorkspaceTypes.h"
#include "IStringHelper.h"

/*!
	CWorkspace ANZXNX
*/
class CWorkspaceAccess :
	protected IWorkspaceAccess, protected IWorkspaceAccessRef
{
public:
	/////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	/////////////////////////////////////////////////////////////////////////////
	CWorkspaceAccess(void);
	CWorkspaceAccess(IWorkspaceAccessPtr access);
	CWorkspaceAccess(IWorkspacePtr root, CUTF8String path);

	/////////////////////////////////////////////////////////////////////////////
	//	C^tF[X擾
	/////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual IWorkspaceAccessPtr GetIWorkspaceAccess() { return this; };

	//!	C^tF[X擾
	virtual IWorkspaceAccessRefPtr GetIWorkspaceAccessRef() { return this; };

	//!	C^tF[X֐ݒ
	virtual void FillIWorkspaceAccessRef(IWorkspaceAccessRefPtr access) { access->SetWorkspaceAccess(GetRoot(), GetPath()); };

	/////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(void);

	//!	(㏑Rs[ATum[hƃL[Rs[邪Ãm[h͕ύXȂ)
	virtual void Copy(CWorkspaceAccess &src);

	//!	ANZXNX擾
	virtual CWorkspaceAccess GetAccess(CUTF8String subPath);

	//!	[g擾
	virtual IWorkspacePtr GetRoot();

	//!	O擾
	virtual CUTF8String GetNodeName();

	//!	pX擾
	virtual CUTF8String GetPath();

	/////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyStr(CUTF8String key, CUTF8String data, int noCase = FALSE);
	virtual void SetKeyInt(CUTF8String key, int data, int noCase = FALSE);
	virtual void SetKeyInt64(CUTF8String key, __int64 data, int noCase = FALSE);
	virtual void SetKeyDWORD(CUTF8String key, DWORD data, int noCase = FALSE);

	//!	f[^̎擾
	virtual CUTF8String GetKeyStr(CUTF8String key, CUTF8String defaultData, int noCase = FALSE);
	virtual int GetKeyInt(CUTF8String key, int defaultData, int noCase = FALSE);
	virtual __int64 GetKeyInt64(CUTF8String key, __int64 defaultData, int noCase = FALSE);
	virtual DWORD GetKeyDWORD(CUTF8String key, DWORD defaultData, int noCase = FALSE);

	//!	f[^̍폜
	virtual void DeleteKey(CUTF8String key);

	//!	L[擾
	virtual int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKey(CUTF8StringArray &list);

	//!	SẴf[^𕶎ƂĎ擾
	virtual int GetAllData(CUTF8StringArray &list);


	/////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(CUTF8String name);

	//!	Tum[h𓾂
	virtual int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(CUTF8StringArray &list);

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////
	//!	
	void Init(IWorkspacePtr root, CUTF8String path);

	/////////////////////////////////////////////////////////////////////////////
	//	IWorkspaceAccessPtr
	/////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void SetWorkspaceAccess(IWorkspacePtr root, LPCU8STR path)
	{
		Init(root, path);
	}

	//!	C^[tF[X擾
	virtual IWorkspacePtr GetIWorkspacePtr()
	{
		return GetRoot();
	}

	//!	pX擾
	virtual void GetAccessPath(IStringPtr path)
	{
		path->SetString(m_path, -1);
	}

	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	//!	̎m[h
	CUTF8String		m_path;

	//!	eWorkspace
	IWorkspacePtr	m_root;
};


/******************************************************************************************/
//	ev[g쐬p}N
/******************************************************************************************/
//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_STR(PropertyName, PropertyPath, DefaultVal) \
	CUTF8String Get##PropertyName(CUTF8String defVal = DefaultVal)	{ return GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CUTF8String val)	{ SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT(PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT64(PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return GetAccess(PropertyPath); };


//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_STR(Access, PropertyName, PropertyPath, DefaultVal) \
	CUTF8String Get##PropertyName(CUTF8String defVal = DefaultVal)	{ return Access.GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CUTF8String val)	{ Access.SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT(Access, PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return Access.GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ Access.SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT64(Access, PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return Access.GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ Access.SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, _U8("")); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, _U8("")).IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return Access.GetAccess(PropertyPath); };


//!	RXgN^܂Ƃ߂Ē`
#define	DEFINE_COMMON_CONSTRUCTOR(className)	\
	className(void) {};\
	className(CWorkspaceAccess  &other)							{ CWorkspaceAccess::operator=(other); };\
	void operator = (CWorkspaceAccess &other)					{ CWorkspaceAccess::operator=(other); };\
	virtual IWorkspaceAccessPtr GetIWorkspaceAccess()			{ return this; };\
	virtual IWorkspaceAccessRefPtr GetIWorkspaceAccessRef()		{ return this; };\
	virtual void FillIWorkspaceAccessRef(IWorkspaceAccessRefPtr access) { access->SetWorkspaceAccess(GetRoot(), GetPath()); };

