/*!
	WorkspaceTypes.h

	Workspace֌W̒`
	ɐ錾ĂC^tF[X́AύXȂB
*/
#pragma once
#include "types/StringTypes.h"
#include "UTF8String.h"


////////////////////////////////////////////////////////////////////////////////////////////////////////
//	CWorkspaceAccess 󂯓nC^tF[X
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	[NXy[Xւ̊OANZX
*/
class IWorkspace
{
public:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(LPCU8STR path) = 0;

	//!	Rs[
	virtual void Copy(LPCU8STR destPath, LPCU8STR srcPath, IWorkspace *srcWorkspace=NULL) = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	r
	/////////////////////////////////////////////////////////////////////////////////////
	//!	bN
	virtual void Lock() = 0;

	//!	AbN
	virtual void Unlock() = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyData(LPCU8STR path, LPCU8STR data, int noCase = FALSE) = 0;

	//!	f[^̎擾
	virtual void GetKeyData(IStringPtr dest, LPCU8STR path, LPCU8STR defaultData, int noCase = FALSE) = 0;

	//!	f[^̍폜
	virtual void DeleteKey(LPCU8STR path) = 0;

	//!	L[擾
	virtual int GetKeyCount(LPCU8STR path) = 0;

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKeyPair(LPCU8STR path, IStringArrayPtr keys, IStringArrayPtr datas) = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(LPCU8STR path) = 0;

	//!	Tum[h𓾂
	virtual int GetSubNodeCount(LPCU8STR path) = 0;

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(LPCU8STR path, IStringArrayPtr list) = 0;
};
//!	|C^^
typedef IWorkspace*	IWorkspacePtr;


/*!
	CWorkspaceAccess
*/
class IWorkspaceAccess
{
public:
	//!	C^[tF[X擾
	virtual IWorkspacePtr	GetIWorkspacePtr() = 0;

	//!	pX擾
	virtual void			GetAccessPath(IStringPtr path) = 0;
};
//!	|C^^
typedef IWorkspaceAccess*	IWorkspaceAccessPtr;


/*!
	CWorkspaceAccess ̃t@X^
*/
class IWorkspaceAccessRef
{
public:
	//!	
	virtual void SetWorkspaceAccess(IWorkspacePtr root, LPCU8STR path) = 0;
};
//!	|C^^
typedef IWorkspaceAccessRef*	IWorkspaceAccessRefPtr;

