#include "StdAfx.h"
#include "UTF8String.h"
#include "UTF8StringTool.h"
#include "UTF8StringConvert.h"
#include "UTF8StringCore.h"
#include "UTF8StringMemoryPool.h"


////////////////////////////////////////////////////////////////////////////////
//	RXgN^
////////////////////////////////////////////////////////////////////////////////
/*!
	RXgN^
*/
CUTF8String::CUTF8String(void)
{
	InitInternal();
}

/*!
	RXgN^(CUTF8String)
*/
CUTF8String::CUTF8String(const CUTF8String &other)
{
	InitInternal();

	//	Rs[
	*this = other;
}

/*!
	RXgN^(LPCU8STR)
*/
CUTF8String::CUTF8String(LPCU8STR other)
{
	InitInternal();

	//	Rs[
	*this = other;
}

/*!
	RXgN^(LPCWSTR)
*/
CUTF8String::CUTF8String(LPCWSTR other)
{
	InitInternal();

	//	Rs[
	*this = other;
}

/*!
	fXgN^
*/
CUTF8String::~CUTF8String(void)
{
	FreeString();
}



////////////////////////////////////////////////////////////////////////////////
//	̑̑
////////////////////////////////////////////////////////////////////////////////
/*!
	ۂɂ
*/
void CUTF8String::Empty()
{
	if(GetLength() > 0)
		GetWritableString(0)[0] = 0;
}

////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////
/*!
	Rs[(UFT8)
*/
void CUTF8String::Copy(LPCU8STR copyFrom, int u8Length, int safetyCheck)
{
	//	NULL?
	if(copyFrom == NULL)
		u8Length = 0;

	//	TCY
	if(u8Length < 0)
		u8Length = strlen((char *)copyFrom);

	//	ہH
	if(u8Length <= 0)
	{
		Empty();
	}
	else
	{
		//	S`FbN
		if(safetyCheck && CUTF8StringTool::CheckIllegalUTF8(copyFrom, u8Length))
		{
			//	̂ŁAUUTF16ɕϊĊi[
			CopyWithUTF16((LPCSTR)copyFrom, u8Length, CP_UTF8);
		}
		else
		{
			//	obt@m
			char *ptr = (char *)GetWritableString(u8Length);

			//	Rs[
			strncpy_s(ptr, u8Length + 1, (char *)copyFrom, u8Length);

			//	ÔߒĐݒ
			GetWritableString(strlen(ptr));
		}
	}
}


/*!
	Rs[(UFT16)
*/
void CUTF8String::CopyUTF16(LPCWSTR copyFrom, int u16Length)
{
	//	NULL?
	if(copyFrom == NULL)
		u16Length = 0;

	//	TCY
	if(u16Length < 0)
		u16Length = wcslen(copyFrom);

	//	ہH
	if(u16Length <= 0)
	{
		Empty();
	}
	else
	{
		//	ϊTCY擾
		int u8Length = ::WideCharToMultiByte(CP_UTF8, 0, copyFrom, u16Length, NULL, 0, NULL, NULL);
		if(u8Length == 0)
		{
			//	G[ۂ̂ł߂
			Empty();
			return;
		}

		//	obt@m
		char *ptr = (char *)GetWritableString(u8Length);

		//	ϊ
		if(::WideCharToMultiByte(CP_UTF8, 0, copyFrom, u16Length, ptr, u8Length, NULL, NULL) == 0)
		{
			//	G[ۂ̂ł߂
			Empty();
			return;
		}

		//	C
		ptr[u8Length] = 0;
	}
}

/*!
	Rs[(MBCS)
*/
void CUTF8String::CopyMBCS(LPCSTR copyFrom, int mbLength)
{
	//	NULL?
	if(copyFrom == NULL)
		mbLength = 0;

	//	TCY
	if(mbLength < 0)
		mbLength = _mbstrlen(copyFrom);

	//	ہH
	if(mbLength <= 0)
	{
		Empty();
	}
	else
	{
		//	SASCIIȂ疳
		if(CUTF8StringTool::CheckAllAscii(copyFrom, mbLength))
			Copy((LPCU8STR)copyFrom, mbLength, FALSE);
		else
			CopyWithUTF16(copyFrom, mbLength, CP_ACP);
	}
}

/*
	CUTF8String𕡐
*/
CUTF8String& CUTF8String::operator=(const CUTF8String &other)
{
	//	폜
	FreeString();

	//	
	if(other.GetLength() > 0)
	{
		//	|C^Rs[ACNg
		m_u8string = other.m_u8string;
		GetStringClass()->IncementRef();
	}

	return(*this);
}

/*
	LPCU8STRRs[
*/
CUTF8String& CUTF8String::operator=(LPCU8STR other)
{
	Copy(other, -1, TRUE);
	return(*this);
}


/*
	LPCWSTRRs[
*/
CUTF8String& CUTF8String::operator=(LPCWSTR other)
{
	CopyUTF16(other, -1);
	return(*this);
}


/*!
	̐ݒ
*/
void CUTF8String::SetString(LPCU8STR toSet, int length)
{
	Copy(toSet, length, TRUE);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	̎擾
*/
LPCU8STR CUTF8String::GetString() const
{
	if(GetStringClass() == NULL)
		return(CUTF8StringTool::GetEmptyString());
	return(GetStringClass()->GetString());
}

/*!
	擾
*/
int CUTF8String::GetLength() const
{
	if(GetStringClass() == NULL)
		return(0);
	return(GetStringClass()->GetLength());
}

/*!
	LPCU8STR
*/
CUTF8String::operator LPCU8STR() const
{
	return GetString();
}

/*!
	[]
*/
utf8_char CUTF8String::operator[](int index) const
{
	ASSERT(index >=0 && index < GetLength());

	return(GetString()[index]);
}

//////////////////////////////////////////////////////////////////////////////////////////
//	r
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	LPCU8STR
*/
int CUTF8String::operator==(LPCU8STR other)
{
	return(Compare(other) == 0);
}


/*!
	LPCWSTR
*/
int CUTF8String::operator==(LPCWSTR other)
{
	return(*this == _cnvU8(other));
}

/*!
	ʂɔr
*/
int CUTF8String::Compare(LPCU8STR other)
{
	return(strcmp((char *)GetString(), (char *)other));
}


/*!
	ʂɔr
*/
int CUTF8String::Compare(LPCWSTR other)
{
	return Compare(_cnvU8(other));
}


/*!
	啶Ŕr
*/
int CUTF8String::CompareNoCase(LPCU8STR other)
{
	return(_strcmpi((char *)GetString(), (char *)other));
}


/*!
	啶Ŕr
*/
int CUTF8String::CompareNoCase(LPCWSTR other)
{
	return CompareNoCase(_cnvU8(other));
}


//////////////////////////////////////////////////////////////////////////////////////////
//	ǉ
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	LPCU8STR
*/
void CUTF8String::operator+=(LPCU8STR other)
{
	Append(other);
}


/*!
	LPCWSTR
*/
void CUTF8String::operator+=(LPCWSTR other)
{
	Append(other);
}

/*!
	utf8_char
*/
void CUTF8String::operator+=(const utf8_char other)
{
	utf8_char	str[2] = { other, 0 };
	Append(str);
}


/*!
	ǉ
*/
void CUTF8String::Append(LPCU8STR other)
{
	//	iȎQƉAŌ폜̂hj
	CUTF8String dest(*this);

	//	擾
	int appendLength = strlen((char*)other);
	int	curLength = dest.GetLength();

	//	Ċm
	utf8_char *str = dest.GetWritableString(curLength + appendLength);

	//	Rs[
	memmove(str + curLength, other, appendLength);

	//	CɂĂ
	str[curLength + appendLength] = 0;

	//	߂
	*this = dest;
}


/*!
	ǉ
*/
void CUTF8String::Append(LPCSTR other)
{
	Append(_cnvU8(other));
}

/*!
	ǉ
*/
void CUTF8String::Append(LPCWSTR other)
{
	Append(_cnvU8(other));
}



//////////////////////////////////////////////////////////////////////////////////////////
//	폜
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	폜
*/
CUTF8String &CUTF8String::Delete(int index, int count)
{
	int curLength = GetLength();

	//	ʒuATCYmF
	if(index < 0)
		index = 0;
	if(index >= curLength)
		return *this;
	if(index + count > curLength)
		count = curLength - index;

	//	TCYvZ
	int newLength = curLength - count;
	int	moveLength = curLength - (index + count);

	//	|C^擾
	utf8_char *str = GetWritableString(newLength);

	//	f[^ړ
	if(moveLength > 0)
		memmove(str + index, str + index + count, moveLength);

	//	C
	str[newLength] = 0;
	
	return *this;
}

/*!
	E폜
*/
CUTF8String &CUTF8String::TrimRight()
{
	//	AANZXp|C^
	int curLength = GetLength();
	LPCU8STR str = GetString();

	//	󔒈ʒu
	for(int i=curLength-1; i>=0; i--)
	{
		if(CUTF8StringTool::IsASCII(str[i]) && !isspace(str[i]))
		{
			//	폜s
			if(i != curLength - 1)
				Delete(i, curLength - i);
			break;
		}
	}

	return *this;
}

/*!
	폜
*/
CUTF8String &CUTF8String::TrimLeft()
{
	//	AANZXp|C^
	int curLength = GetLength();
	LPCU8STR str = GetString();

	//	󔒈ʒu
	for(int i=0; i<curLength; i++)
	{
		if(CUTF8StringTool::IsASCII(str[i]) && !isspace(str[i]))
		{
			//	폜s
			if(i != 0)
				Delete(0, i);
			break;
		}
	}

	return *this;
}

/*!
	󔒂폜
*/
CUTF8String &CUTF8String::Trim()
{
	return(TrimLeft().TrimRight());
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Left, Right
//////////////////////////////////////////////////////////////////////////////////////////
//!	E폜
CUTF8String CUTF8String::Right(int count)
{
	if(count > GetLength())
		count = GetLength();
	if(count < 0)
		return(CUTF8StringTool::GetEmptyString());

	return Mid(GetLength() - count, count);
}

//!	폜
CUTF8String CUTF8String::Left(int count)
{
	if(count > GetLength())
		count = GetLength();
	if(count < 0)
		return(CUTF8StringTool::GetEmptyString());

	return Mid(0, count);
}

/*!
	wʒu擾
*/
CUTF8String CUTF8String::Mid(int index, int count)
{
	//	擾
	int	curLength = GetLength();

	//	mF
	if(index < 0)
		index = 0;

	//	ʂ͋
	if(count == 0 || index >= curLength)
		return(CUTF8StringTool::GetEmptyString());

	//	JEg擾
	if(count < 0 || index + count > curLength)
		count = curLength - index;

	//	|C^擾
	CUTF8String	ret;
	LPSTR dest = (LPSTR)ret.GetWritableString(count);
	LPSTR src = (LPSTR)GetString();

	//	Rs[
	memmove(dest, src + index, count);
	dest[count] = 0;

	return(ret);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Eu
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CUTF8String::Find(LPCU8STR find, int start)
{
	//	ʒu`FbN
	if(start < 0 || start >= GetLength())
		return(-1);

	//	ANZXp|C^
	LPCSTR str = (LPCSTR)GetString();

	//	
	LPCSTR ptr = strstr(str + start, (LPCSTR)find);
	if(ptr == NULL)
		return(-1);

	return(ptr - str);
}


/*!
	
*/
int CUTF8String::Find(LPCWSTR find, int start)
{
	return Find(_cnvU8(find), start);
}


/*!
	΂T
*/
int CUTF8String::ReverseFind(utf8_char ch)
{
	//	ANZXp|C^
	LPCSTR str = (LPCSTR)GetString();

	//	
	LPCSTR ptr = strrchr(str, ch);
	if(ptr == NULL)
		return(-1);

	return(ptr - str);
}

/*!
	u
*/
int CUTF8String::Replace(LPCU8STR oldTok, LPCU8STR newTok)
{
	//	TCY
	int	curLen = GetLength();
	int oldTokLen = strlen((char *)oldTok);
	int newTokLen = strlen((char *)newTok);

	//	܂v擾
	int	index = 0, count = 0;
	while(1)
	{
		//	
		index = Find(oldTok, index);
		if(index == -1)
			break;

		//	
		index += oldTokLen;
		count++;
	}


	//	VTCY
	int newLength = curLen + (newTokLen - oldTokLen) * count;
	ASSERT(newLength >= 0);

	//	
	CUTF8String	src(*this);

	//	|C^擾
	LPSTR destPtr = (LPSTR)GetWritableString(newLength);
	LPCSTR srcPtr = (LPCSTR)src.GetString();

	//	
	int	destBufLet = newLength;
	while(1)
	{
		//	
		LPCSTR find = strstr(srcPtr, (LPCSTR)oldTok);
		if(find == NULL)
		{
			//	ُ
			ASSERT(strlen(srcPtr) == destBufLet);

			//	c܂Ƃ߂ăRs[
			strcpy_s(destPtr, destBufLet + 1, srcPtr);
			break;
		}
		
		//	ړ
		int moved = find - srcPtr;

		//	vRs[
		memmove(destPtr, srcPtr, moved);
		destPtr += moved;

		//	g[NRs[
		memmove(destPtr, newTok, newTokLen);
		destPtr += newTokLen;

		//	|C^ړ
		srcPtr = find + oldTokLen;

		//	obt@Ǘ
		destBufLet -= (moved + newTokLen);
		ASSERT(destBufLet >= 0);
	}

	return(count);
}


/*!
	u
*/
int CUTF8String::Replace(LPCWSTR oldTok, LPCWSTR newTok)
{
	return Replace(_cnvU8(oldTok), _cnvU8(newTok));
}

//////////////////////////////////////////////////////////////////////////////////////////
//	ϊ
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	g֕ϊ
*/
CUTF8String &CUTF8String::MakeLower()
{
	//	AANZXp|C^
	int curLength = GetLength();
	LPU8STR str = GetWritableString(curLength);

	//	啶
	for(int i=0; i<curLength; i++)
	{
		if(CUTF8StringTool::IsASCII(str[i]) && isupper(str[i]))
			str[i] = str[i] - (unsigned)'A' + (unsigned)'a';
	}

	return(*this);
}

/*!
	g啶֕ϊ
*/
CUTF8String &CUTF8String::MakeUpper()
{
	//	AANZXp|C^
	int curLength = GetLength();
	LPU8STR str = GetWritableString(curLength);

	//	啶
	for(int i=0; i<curLength; i++)
	{
		if(CUTF8StringTool::IsASCII(str[i]) && islower(str[i]))
			str[i] = str[i] - (unsigned)'a' + (unsigned)'A';
	}

	return(*this);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Format
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Format
*/
CUTF8String &CUTF8String::Format(LPCU8STR format, ...)
{
	va_list argList;
	va_start(argList, format);
	FormatV(format, argList);
	va_end(argList);

	return *this;
}


/*!
	Format

	̕UTF8֎ϊȂ
*/
CUTF8String &CUTF8String::Format(LPCWSTR format, ...)
{
	va_list argList;
	va_start(argList, format);
	FormatV(_cnvU8(format), argList);
	va_end(argList);

	return *this;
}

/*!
	Format
*/
CUTF8String &CUTF8String::FormatV(LPCU8STR format, va_list argptr)
{
	//	擾
	int len = _vscprintf((LPSTR)format, argptr );

	//	݃obt@擾
	LPSTR str = (LPSTR)GetWritableString(len);

	//	
	vsprintf_s(str, len + 1, (LPSTR)format, argptr);

	return *this;
}


/*!
	Format

	̕UTF8֎ϊȂ
*/
CUTF8String &CUTF8String::FormatV(LPCWSTR format, va_list argptr)
{
	return FormatV(_cnvU8(format), argptr);
}


/*!
	Format(ڎ擾)
*/
CUTF8String CUTF8String::GetFormat(LPCU8STR format, ...)
{
	CUTF8String	ret;

	va_list argList;
	va_start(argList, format);
	ret.FormatV(format, argList);
	va_end(argList);

	return ret;
}

/*!
	Format(ڎ擾)
*/
CUTF8String CUTF8String::GetFormat(LPCWSTR format, ...)
{
	CUTF8String	ret;

	va_list argList;
	va_start(argList, format);
	ret.FormatV(format, argList);
	va_end(argList);

	return ret;
}


////////////////////////////////////////////////////////////////////////////////
//	obt@
////////////////////////////////////////////////////////////////////////////////
//!	NX擾
__inline CUTF8StringData *CUTF8String::GetStringClass() const
{
	if(m_u8string == NULL)
		return(NULL);

	LPU8STR	strPtr = (LPU8STR)m_u8string;
	return (CUTF8StringData*)(strPtr - sizeof(CUTF8StringData));
}

/*!
	
*/
void CUTF8String::SetStringClass(CUTF8StringData *strClass)
{
	FreeString();

	LPU8STR	strPtr = (LPU8STR)strClass;
	m_u8string = strPtr + sizeof(CUTF8StringData);
}


////////////////////////////////////////////////////////////////////////////////
//	⏕
////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CUTF8String::InitInternal()
{
	//	̃RpCł́AgpsII
	ASSERT(sizeof(LPU8STR) == sizeof(CUTF8String));

	//	
	m_u8string = NULL;
}

/*!
	KvȂ
*/
void CUTF8String::FreeString()
{
	//	QƃJE^炷
	if(GetStringClass() != NULL)
		GetStringClass()->DecrementRef();
	m_u8string = NULL;
}

/*!
	ݗp擾
*/
LPU8STR CUTF8String::GetWritableString(int length)
{
	//	݂Ȃ
	if(GetStringClass() == NULL)
	{
		//	VK
		SetStringClass(CUTF8StringData::GetNewString(length));
	}
	else if(!GetStringClass()->CanWrite() || GetStringClass()->SetLength(length))	//	ݕs\ or Ȃ
	{
		//	
		CUTF8StringData *newString = CUTF8StringData::GetNewString(length, GetStringClass(), (length > GetLength()));

		//	ݒ肷
		SetStringClass(newString);
	}

	//	ݗpobt@擾
	return(GetStringClass()->GetWritableString());
}


/*!
	UUTF16ɂčĐݒ
*/
void CUTF8String::CopyWithUTF16(LPCSTR mbStr, int mbLength, int charSet)
{
	//	ƃobt@m
	CUTF8StringTempBuf	utf16Buf;

	//	ϊ
	LPCWSTR				utf16 = CUTF8StringTool::AnyToUTF16(mbStr, mbLength, utf16Buf, charSet);

	//	UTF16ƂĐݒ
	CopyUTF16(utf16, -1);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	}l[W
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	O[ov[Lɂ(ł\Aɂ͂łȂ)
*/
void CUTF8String::EnableMemoryPool()
{
	g_utf8StringMemoryPool.EnableMemoryPool();
}

/*!
	݂̎gp񐔎擾(v[ȊO܂)
*/
int CUTF8String::GetGlobalStringCount()
{
	return g_utf8StringMemoryPool.GetAllocedCount();
}

/*!
	݂̃v[TCY擾
*/
int CUTF8String::GetMemoryPoolSize()
{
	return g_utf8StringMemoryPool.GetPoolSize();
}


//////////////////////////////////////////////////////////////////////////////////////////
//	ZiO[oZqƂj
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	CUTF8String
*/
CUTF8String operator+(const CUTF8String &arg1, const CUTF8String &arg2)
{
	CUTF8String	ret(arg1);
	ret.Append(arg2);

	return(ret);
}

/*!
	LPCU8STR
*/
CUTF8String operator+(const CUTF8String arg1, const LPCU8STR arg2)
{
	CUTF8String	ret(arg1);
	ret.Append(arg2);

	return(ret);
}


/*!
	LPCWSTR
*/
CUTF8String operator+(const CUTF8String arg1, const LPCWSTR arg2)
{
	CUTF8String	ret(arg1);
	ret.Append(arg2);

	return(ret);
}


/*!
	LPCU8STR
*/
CUTF8String operator+(const LPCU8STR arg1, const CUTF8String arg2)
{
	CUTF8String	ret(arg1);
	ret.Append(arg2);

	return(ret);
}


/*!
	LPCWSTR
*/
CUTF8String operator+(const LPCWSTR arg1, const CUTF8String arg2)
{
	CUTF8String	ret(arg1);
	ret.Append(arg2);

	return(ret);
}

