#include "StdAfx.h"
#include "UTF8StringMemoryPool.h"

//!	O[o
CUTF8StringMemoryPool g_utf8StringMemoryPool;

CUTF8StringMemoryPool::CUTF8StringMemoryPool(void)
{
	m_enable = 0;
	m_stringCount = 0;
}

CUTF8StringMemoryPool::~CUTF8StringMemoryPool(void)
{
	m_enable = 0;

	//	J`FbN
	ASSERT(m_stringCount == 0);
}


/*!
	Lɂ
*/
void CUTF8StringMemoryPool::EnableMemoryPool()
{
	CRITICAL_SECTION_SCOPE();

	//	Lς
	if(m_enable)
		return;

	//	v[
	m_memoryPool.Init(UTF8STRING_POOL_BLOCK_SIZE, UTF8STRING_CHUNK_SIZE);
	m_memoryPool.PreCharge();
}


/*!
	mۂ
*/
unsigned char *CUTF8StringMemoryPool::Alloc(int size)
{
	CRITICAL_SECTION_SCOPE();
	m_stringCount++;

	//	Lς?
	if(!m_enable)
		return new unsigned char[size];

	//	v[m
	return((unsigned char *)m_memoryPool.Alloc(size));
}

/*!
	
*/
void CUTF8StringMemoryPool::Free(unsigned char *block)
{
	CRITICAL_SECTION_SCOPE();
	m_stringCount--;
	ASSERT(m_stringCount >= 0); //	

	//	Lς?
	if(!m_enable)
	{
		delete block;
		return;
	}

	//	v[݂
	if(m_memoryPool.TryFree(block))
		delete block;
}


/*!
	񐔎擾
*/
int CUTF8StringMemoryPool::GetAllocedCount()
{
	CRITICAL_SECTION_SCOPE();

	return(m_stringCount);
}


/*!
	v[TCY擾
*/
int CUTF8StringMemoryPool::GetPoolSize()
{
	CRITICAL_SECTION_SCOPE();

	//	Lς?
	if(!m_enable)
		return(0);

	return(m_memoryPool.GetChunkCount() * UTF8STRING_POOL_BLOCK_SIZE * UTF8STRING_CHUNK_SIZE);
}

