#include "StdAfx.h"
#include "WorkspaceXMLWriter.h"
#include "TextEscape.h"
#include "UTF8StringConvert.h"

#define	TAB_WRITE_COUNT	100

/////////////////////////////////////////////////////////////////////////////
//	o͊֐
/////////////////////////////////////////////////////////////////////////////
/*!
	RXgN^
*/
CWorkspaceXMLWriter::CWorkspaceXMLWriter(void)
{
}

/*
	fXgN^
*/
CWorkspaceXMLWriter::~CWorkspaceXMLWriter(void)
{
}


/////////////////////////////////////////////////////////////////////////////
//	o
/////////////////////////////////////////////////////////////////////////////
/*!
	XMLo(throw CWorkspaceXMLWriterException)
*/
CUTF8String CWorkspaceXMLWriter::ToString(CWorkspaceNode *root, CUTF8String workspaceClassType)
{
	//	NX^Cvݒ
	m_workspaceClassType = workspaceClassType;

	//	obt@
	m_xml.Empty();
	m_xml.SetGrowSize(65536);

	//	wb_o
	WriteHeader();

	//	f[^o
	CTextEscape	escape;
	escape.AddEscape(_U8("<"), _U8("&lt;"));
	escape.AddEscape(_U8(">"), _U8("&gt;"));
	escape.AddEscape(_U8("&"), _U8("&amp;"));
	WriteSubNode(root, escape, 1);

	//	tb^o
	WriteFooter();

	//	UTF8֕ϊ
	return m_xml;
}

/*!
	t@C֏o
*/
int CWorkspaceXMLWriter::SaveToFile(CWorkspaceNode *root, CUTF8String path, CUTF8String workspaceClassType)
{
	CUTF8String utf8 = ToString(root, workspaceClassType);

	//	J
	FILE	*out;
	if(fopen_s(&out, _cnvMBCS(path), "wb") != 0)
		return(-1);

	//	oCgI[_[}[N
	fputc(0xEF, out);
	fputc(0xBB, out);
	fputc(0xBF, out);

	//	{o
	fwrite((LPCU8STR)utf8, utf8.GetLength(), 1, out);
	fclose(out);
	return(0);
}


/////////////////////////////////////////////////////////////////////////////
//	o͊֐
/////////////////////////////////////////////////////////////////////////////
/*!
	wb_[o
*/
void CWorkspaceXMLWriter::WriteHeader()
{
	m_xml.AppendLPCSTR("<?xml version=\"1.0\"?>\r\n<!--Soft3304 CWorkspace class.-->\r\n<CWorkspaceClass type=\"");
	m_xml.AppendString(m_workspaceClassType);
	m_xml.AppendLPCSTR("\">\r\n");
}

/*!
	tb^[o
*/
void CWorkspaceXMLWriter::WriteFooter()
{
	m_xml.AppendLPCSTR("</CWorkspaceClass>\r\n");
}


/*!
	Pm[ho
*/
void CWorkspaceXMLWriter::WriteSubNode(CWorkspaceNode *node, CTextEscape &escape, int tabCount)
{
	//	o
	WriteTab(tabCount);
	m_xml.AppendLPCSTR("<Subnode name=\"");
	m_xml.AppendLPCU8STR(node->GetNodeName());
	m_xml.AppendLPCSTR("\">\r\n");

	//	L[o
	for(int i=0;;i++)
	{
		CWorkspaceKeyPair *key = node->GetKeyByIndex(i);
		if(key == NULL)
			break;

		//	o
		WriteTab(tabCount);
		m_xml.AppendLPCSTR("\t<Key name=\"");
		m_xml.AppendLPCU8STR(key->GetKey());
		m_xml.AppendLPCSTR("\">");
		m_xml.AppendLPCU8STR(escape.Escape(key->GetData()));
		m_xml.AppendLPCSTR("</Key>\r\n");
	}

	//	Tum[ho
	for(int i=0;;i++)
	{
		CWorkspaceNode *subnode = node->GetSubNodeByIndex(i);
		if(subnode == NULL)
			break;

		//	o
		WriteSubNode(subnode, escape, tabCount + 1);
	}

	//	
	WriteTab(tabCount);
	m_xml.AppendLPCSTR("</Subnode>\r\n");
}


/*!
	^uǉ
*/
void CWorkspaceXMLWriter::WriteTab(int tabCount)
{
	char	tabs[TAB_WRITE_COUNT];

	//	^u
	memset(tabs, '\t', TAB_WRITE_COUNT);
	while(tabCount > 0)
	{
		if(tabCount <= TAB_WRITE_COUNT)
		{
			m_xml.Append(tabs, tabCount);
			break;
		}
		else
		{
			m_xml.Append(tabs, TAB_WRITE_COUNT);
			tabCount -= TAB_WRITE_COUNT;
		}
	}
}

