#include "StdAfx.h"
#include "SimpleMemoryPool.h"

/***************************************************************************/
//	CSimpleMemoryPoolChunk
/***************************************************************************/
CSimpleMemoryPoolChunk::CSimpleMemoryPoolChunk()
{
	m_controlBlock = NULL;
	m_buf = NULL;
	m_blockSize = 0;
	m_poolSize = 0;
	m_usingCount = 0;
}

CSimpleMemoryPoolChunk::~CSimpleMemoryPoolChunk()
{
	Close();
}

//////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////
/*!
	
*/
int CSimpleMemoryPoolChunk::Init(int blockSize, int blockCount)
{
	//	JĂ
	Close();

	//	ϐ
	m_blockSize = blockSize;
	m_poolSize = blockCount;

	//	m
	char *newData = new char[(sizeof(SSimpleMemoryPoolSubChunk) * blockCount) + (blockSize * blockCount)];
	if(newData == NULL)
		return(-1);

	//	ϐ
	m_controlBlock = (SSimpleMemoryPoolSubChunk *)newData;
	m_buf = newData + (sizeof(SSimpleMemoryPoolSubChunk) * blockCount);

	//	\̏
	memset(m_controlBlock, 0, sizeof(SSimpleMemoryPoolSubChunk) * blockCount);

	return(0);
}

/*!
	I
*/
void CSimpleMemoryPoolChunk::Close()
{
	//	J`FbN
	ASSERT(m_usingCount == 0);

	if(m_controlBlock)
		delete (char *)m_controlBlock;

	m_controlBlock = NULL;
	m_buf = NULL;
	m_blockSize = 0;
	m_poolSize = 0;
	m_usingCount = 0;
}



/*!
	m
*/
void *CSimpleMemoryPoolChunk::Alloc(int blockCount)
{
	ASSERT(blockCount > 0 && blockCount <= m_poolSize);

	//	܂ł
	if(GetFreeCount() < blockCount)
		return(NULL);

	//	
	for(int i=0;i<m_poolSize;)
	{
		if(m_controlBlock[i].m_using == 0)
		{
			if(blockCount == 1)
			{
				return(MarkToUsing(i, 1));
			}
			else
			{
				//	A󂫗eʎ擾
				int count = GetFreeBlockSize(i, blockCount);
				if(count >= blockCount)
					return(MarkToUsing(i, blockCount));
				else
					i += count;
			}
		}
		else
		{
			//	gpړ
			i += GetUsingBlockSize(i);
		}
	}

	//	s
	return(NULL);
}

/*!
	J

	TRUE:AFALSE:
*/
int CSimpleMemoryPoolChunk::Free(void *toFree)
{
	int index = GetBlockIndex(toFree);
	if(index == -1)
		return(FALSE);

	MarkToFree(index);
	return(TRUE);
}



//////////////////////////////////////////////////////////////
//	⏕
//////////////////////////////////////////////////////////////
/*!
	|C^ubNCfbNX擾
*/
int CSimpleMemoryPoolChunk::GetBlockIndex(void *toFree)
{
	char *ptr = (char *)toFree;

	//	ʒu`FbN
	if(ptr < m_buf || ptr > m_buf + m_blockSize * (m_poolSize - 1))
		return(-1);

	//	擾
	int offset = ptr - m_buf;
	return(offset / m_blockSize);
}

/*!
	A󂫗eʂ̎擾
*/
int CSimpleMemoryPoolChunk::GetFreeBlockSize(int startIndex, int maxCount)
{
	int	count = 0;
	for(int i=startIndex;i<m_poolSize;i++)
	{
		if(m_controlBlock[i].m_using || count >= maxCount)
			break;
		count++;
	}
	return(count);
}

/*!
	Agpeʂ̎擾
*/
int CSimpleMemoryPoolChunk::GetUsingBlockSize(int startIndex)
{
	return(m_controlBlock[startIndex].m_blockSize);
}


/*!
	gpɂ
*/
void *CSimpleMemoryPoolChunk::MarkToUsing(int startIndex, int count)
{
	//	擪擾
	SSimpleMemoryPoolSubChunk *ptr = &(m_controlBlock[startIndex]);

	//	gpɃ}[N
	ASSERT(ptr->m_using == 0);
	ASSERT(ptr->m_blockSize == 0);
	ptr->m_using = 1;
	ptr->m_blockSize = count;

	//	c̃ubN}[N
	for(int i=0;i<count-1;i++)
	{
		ptr++;
		ASSERT(ptr->m_using == 0);
		ASSERT(ptr->m_blockSize == 0);
		ptr->m_using = 1;
		ptr->m_blockSize = -1;
	}

	//	gp
	m_usingCount += count;

	return(m_buf + (m_blockSize * startIndex));
}

/*!
	󂫂ɂ
*/
void CSimpleMemoryPoolChunk::MarkToFree(int startIndex)
{
	//	擪擾
	SSimpleMemoryPoolSubChunk *ptr = &(m_controlBlock[startIndex]);

	//	TCY擾
	ASSERT(ptr->m_using != 0);
	ASSERT(ptr->m_blockSize != 0 && ptr->m_blockSize != -1);
	int count = ptr->m_blockSize;

	//	󂫂Ƀ}[N
	ptr->m_using = 0;
	ptr->m_blockSize = 0;

	//	c󂫂Ƀ}[N
	for(int i=0;i<count-1;i++)
	{
		ptr++;
		ASSERT(ptr->m_using != 0);
		ASSERT(ptr->m_blockSize == -1);
		ptr->m_using = 0;
		ptr->m_blockSize = 0;
	}

	//	gp
	m_usingCount -= count;
}

/***************************************************************************/
//	CSimpleMemoryPool
/***************************************************************************/
//////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////
CSimpleMemoryPool::CSimpleMemoryPool()
{
	m_blockSize = 0;
	m_growCount = 0;
	m_init = 0;
}

CSimpleMemoryPool::~CSimpleMemoryPool(void)
{
	Close();
}

//////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////
/*!
	
*/
void CSimpleMemoryPool::Init(int blockSize, int growCount)
{
	Close();

	//	
	m_blockSize = blockSize;
	m_growCount = growCount;
	m_init = TRUE;
}

/*!
	mۂĂ
*/
void CSimpleMemoryPool::PreCharge()
{
	//	KvȂm
	Grow();
}


/*!
	m
*/
void *CSimpleMemoryPool::Alloc(int size)
{
	//	mF
	ASSERT(m_init);
	if(!m_init)
		return(NULL);

	//	mۃTCYvZ
	int blockCount = size / m_blockSize;
	if(size % m_blockSize != 0)	//	؂ȂH
		blockCount++;

	//	TCYI[o[Ȃ̂ŁAOɊm
	if(blockCount > m_growCount)
	{
		char *extBlock = new char[m_blockSize * blockCount];
		m_extBlocks.Add(extBlock);
		return (void *)extBlock;
	}

	//	xmۂ݂
	void *ptr = TryAlloc(blockCount);
	if(ptr == NULL)
	{
		//	݂
		if(Grow())
			return(NULL);

		//	ēxgC
		ptr = TryAlloc(blockCount);
	}

	ASSERT(ptr != NULL);
	return(ptr);
}

/*!
	J
*/
int CSimpleMemoryPool::TryFree(void *toFree)
{
	//	mF
	ASSERT(m_init);
	if(!m_init)
		return(-1);

	//	OubNŊJĂ݂
	if(TryFreeExtBlock(toFree))
		return(0);

	//	
	if(TryFreeManaged(toFree))
		return(0);
	return(-1);
}


/*!
	J
*/
void CSimpleMemoryPool::Free(void *toFree)
{
	//	
	ASSERT(TryFree(toFree) == 0);
}

/*!
	݂̃`N擾
*/
int CSimpleMemoryPool::GetChunkCount()
{
	return m_memoryPools.GetCount();
}


//////////////////////////////////////////////////////////////
//	⏕
//////////////////////////////////////////////////////////////
/*!
	傳
*/
int CSimpleMemoryPool::Grow()
{
	//	KvH
	if(GetFreePoolCount() > 0)
		return(0);

	//	m
	CSimpleMemoryPoolChunk *newPool = new CSimpleMemoryPoolChunk;
	if(newPool == NULL || newPool->Init(m_blockSize, m_growCount))
	{
		if(newPool)
			delete newPool;
		return(-1);
	}
	m_memoryPools.Add(newPool);

	return(0);
}

/*!
	
*/
int CSimpleMemoryPool::Slim()
{
	//	KvH
	if(GetFreePoolCount() <= 1)
		return(0);

	//	
	for(int i=0;i<m_memoryPools.GetCount();i++)
	{
		if(m_memoryPools[i]->GetAllocedCount() == 0)
		{
			delete m_memoryPools[i];
			m_memoryPools.RemoveAt(i);
			return(0);
		}
	}
	return(0);
}

/*!
	݂̊S󂫃v[擾
*/
int CSimpleMemoryPool::GetFreePoolCount()
{
	int	count = 0;
	for(int i=0;i<m_memoryPools.GetCount();i++)
	{
		if(m_memoryPools[i]->GetAllocedCount() == 0)
			count++;
	}
	return(count);
}

/*!
	
*/
void CSimpleMemoryPool::Close()
{
	if(!m_init)
		return;

	//	J
	for(int i=0;i<m_memoryPools.GetCount();i++)
		delete m_memoryPools[i];
	m_memoryPools.RemoveAll();

	m_init = 0;
}


/*!
	mۂ݂
*/
void *CSimpleMemoryPool::TryAlloc(int blockCount)
{
	//	mۂ݂
	for(int i=0;i<m_memoryPools.GetCount();i++)
	{
		void *ptr = m_memoryPools[i]->Alloc(blockCount);
		if(ptr)
			return(ptr);
	}

	return(NULL);
}


/*!
	gubNȂA

	TRUE:AFALSE:
*/
int CSimpleMemoryPool::TryFreeExtBlock(void *ptr)
{
	for(int i=0;i<m_extBlocks.GetCount();i++)
	{
		if(m_extBlocks[i] == (char *)ptr)
		{
			delete m_extBlocks[i];
			m_extBlocks.RemoveAt(i);
			return(TRUE);
		}
	}
	return(FALSE);
}


/*!
	݂

	TRUE:AFALSE:
*/
int CSimpleMemoryPool::TryFreeManaged(void *ptr)
{
	//	݂
	for(int i=0;i<m_memoryPools.GetCount();i++)
	{
		if(m_memoryPools[i]->Free(ptr))
		{
			//	KvȂ烁v[J
			if(m_memoryPools[i]->GetAllocedCount() == 0)
				Slim();
			return(TRUE);
		}
	}

	return(FALSE);
}
