/*!
	SyncObject.h

	IuWFNgǗNX
*/
#pragma once

//	nh
#ifndef SAFE_CLOSE_HANDLE
	#define	SAFE_CLOSE_HANDLE(x)	if(x!=NULL && x!=INVALID_HANDLE_VALUE) ::CloseHandle(x); x = NULL;
#endif

/**********************************************************************************************/
//	Interlocked
/**********************************************************************************************/
/*!
	InterlockedJE^
*/
class CInterlockCounter
{
public:
	//	
	CInterlockCounter()
	{
		::InterlockedExchange(&m_counter,0);
	};

	//	CNg
	__inline int IncCounter()
	{
		return(::InterlockedIncrement(&m_counter));
	};

	//	fNg
	__inline int DecCounter()
	{
		return(::InterlockedDecrement(&m_counter));
	};

	//	Z
	__inline int AddCounter(int add)
	{
		return(::InterlockedExchangeAdd(&m_counter, add));
	};

	//	擾
	__inline int GetCounter()
	{
		return(::InterlockedExchangeAdd(&m_counter,0));
	};

	//	ݒ
	__inline void SetCounter(int count)
	{
		::InterlockedExchange(&m_counter,count);
	};

	///////////////////////////////////////////////////////////////////
	//	Zq
	///////////////////////////////////////////////////////////////////
	//	擾
	__inline operator int()
	{
		return(::InterlockedExchangeAdd(&m_counter,0));
	};

	//	ݒ
	__inline void operator=(const int &other)
	{
		::InterlockedExchange(&m_counter,other);
	};

protected:
	/////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////
	//!	JE^
	LONG	m_counter;
};



/**********************************************************************************************/
//	NeBJZNV
/**********************************************************************************************/
/*!
	NeBJZNVbp
*/
class CSyncCriticalSection
{
public:

	CSyncCriticalSection(void)
	{
		//	
		::InitializeCriticalSection(&m_criticalSection);
	}

	virtual ~CSyncCriticalSection(void)
	{
		//	폜
		::DeleteCriticalSection(&m_criticalSection);
	}


	///////////////////////////////////////////////////////////////////////////////////
	//	bNEAbN
	///////////////////////////////////////////////////////////////////////////////////
	/*!
		bN
	*/
	void Lock()
	{
		EnterCriticalSection(&m_criticalSection);
	}

	/*!
		AbN
	*/
	void Unlock()
	{
		LeaveCriticalSection(&m_criticalSection);
	}

	/*!
		gC
	*/
	int TryLock()
	{
		//	bN݂
		if(!TryEnterCriticalSection(&m_criticalSection))
			return(-1);	//	s
		return(0);
	}


protected:
	///////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV\
	CRITICAL_SECTION	m_criticalSection;
};


/*!
	NeBJZNVXR[v

	CX^X̃XbhԋL֎~I
*/
class CCriticalScope
{
public:
	///////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////////////////////
	/*!
		RXgN^ibNj
	*/
	CCriticalScope(CSyncCriticalSection *criticalSection)
	{
		ASSERT(criticalSection != NULL);
		m_criticalSection = criticalSection;
		m_criticalSection->Lock();
	}

	/*!
		fXgN^iAbNj
	*/
	virtual ~CCriticalScope()
	{
		ASSERT(m_criticalSection != NULL);
		m_criticalSection->Unlock();
		m_criticalSection = NULL;
	}

protected:
	///////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV\
	CSyncCriticalSection	*m_criticalSection;
};

/*!
	}N
*/
#define	CRITICAL_SECTION_SCOPE() CCriticalScope _scopeLock(&m_scopeLock);


/**********************************************************************************************/
//	Mutex, Semaphore, Event, Timer
/**********************************************************************************************/
/*!
	CreateMutexێ֐
*/
class CSyncMutex
{
public:
	///////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CSyncMutex()
	{
		m_mutex = NULL;
	};
	
	/*!
		fXgN^
	*/
	virtual ~CSyncMutex()
	{
		Close();
	};


	///////////////////////////////////////////////////////////////////
	//	쐬Ej
	///////////////////////////////////////////////////////////////////
	/*!
		쐬
	*/
	int Create(BOOL bInitialOwner)
	{
		Close();

		m_mutex = ::CreateMutex(NULL,bInitialOwner,NULL);
		if(m_mutex == NULL)
			return(-1);
		return(0);
	}

	/*!
		
	*/
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_mutex);
	}


	///////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////
	/*!
		nh̎擾
	*/
	__inline operator HANDLE()
	{
		ASSERT(m_mutex != NULL);
		return m_mutex;
	};


	/*!
		~[ebNXJ
	*/
	void ReleaseMutex()
	{
		ASSERT(m_mutex != NULL);
		::ReleaseMutex(m_mutex);
	};

protected:
	///////////////////////////////////////////////////////////////////
	//	o
	///////////////////////////////////////////////////////////////////
	//!	~[ebNX
	HANDLE	m_mutex;
};


/*!
	CreateEventێ֐
*/
class CSyncEvent
{
public:
	///////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CSyncEvent()
	{
		m_event = NULL;
	};
	
	/*!
		fXgN^
	*/
	virtual ~CSyncEvent()
	{
		Close();
	};

	///////////////////////////////////////////////////////////////////
	//	쐬Ej
	///////////////////////////////////////////////////////////////////
	/*!
		쐬
	*/
	int Create(BOOL bManualReset, BOOL bInitialState)
	{
		Close();

		m_event = ::CreateEvent(NULL,bManualReset,bInitialState,NULL);
		if(m_event == NULL)
			return(-1);
		return(0);
	}

	/*!
		
	*/
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_event);
	}

	///////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////
	/*!
		nh̎擾
	*/
	__inline operator HANDLE()
	{
		ASSERT(m_event != NULL);
		return m_event;
	}

	/*!
		Zbg
	*/
	void SetEvent()
	{
		ASSERT(m_event != NULL);
		::SetEvent(m_event);
	}

	/*!
		Zbg
	*/
	void ResetEvent()
	{
		ASSERT(m_event != NULL);
		::ResetEvent(m_event);
	}

protected:
	///////////////////////////////////////////////////////////////////
	//	o
	///////////////////////////////////////////////////////////////////
	//!	Cxg
	HANDLE	m_event;
};


/*!
	CSyncSemaphoreێ֐
*/
class CSyncSemaphore
{
public:
	///////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CSyncSemaphore()
	{
		m_semaphore = NULL;
	};
	
	/*!
		fXgN^
	*/
	virtual ~CSyncSemaphore()
	{
		Close();
	};

	///////////////////////////////////////////////////////////////////
	//	쐬Ej
	///////////////////////////////////////////////////////////////////
	/*!
		쐬
	*/
	int Create(LONG lInitialCount, LONG lMaximumCount)
	{
		Close();

		m_semaphore = ::CreateSemaphore(NULL,lInitialCount,lMaximumCount,NULL);
		if(m_semaphore == NULL)
			return(-1);
		return(0);
	}

	/*!
		
	*/
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_semaphore);
	}

	///////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////
	/*!
		nh̎擾
	*/
	__inline operator HANDLE()
	{
		ASSERT(m_semaphore != NULL);
		return m_semaphore;
	}

	/*!
		Z}tHJ
	*/
	void ReleaseSemaphore(LONG count, LPLONG pCount = NULL)
	{
		ASSERT(m_semaphore != NULL);
		::ReleaseSemaphore(m_semaphore, count, pCount);
	}

protected:
	///////////////////////////////////////////////////////////////////
	//	o
	///////////////////////////////////////////////////////////////////
	//!	Z}tH
	HANDLE	m_semaphore;
};



/**********************************************************************************************/
//	I/O Complete port
/**********************************************************************************************/
/*!
	IOCP
*/
class CIOCompletePort
{
public:
	///////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CIOCompletePort()
	{
		m_hIocp = NULL;
	};

	/*!
		fXgN^
	*/
	virtual ~CIOCompletePort()
	{
		Close();
	};
	
	
	///////////////////////////////////////////////////////////////////
	//	쐬Ej
	///////////////////////////////////////////////////////////////////
	/*!
		쐬
	*/
	int Create(int NumberOfConcurrentThreads, HANDLE attach = INVALID_HANDLE_VALUE, int key = 0)
	{
		Close();

		m_hIocp = CreateIoCompletionPort(attach, NULL, key, NumberOfConcurrentThreads);
		if(m_hIocp == NULL)
			return(-1);

		return(0);
	};

	/*!
		
	*/
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_hIocp);
	}

	///////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////
	/*!
		蓖	
	*/
	int SetToDeviceHANDLE(HANDLE hDevice, ULONG_PTR dwCompKey)
	{
		ASSERT(m_hIocp != NULL);
		HANDLE ret = CreateIoCompletionPort(hDevice, m_hIocp, dwCompKey, 0);
		if(ret != m_hIocp)
			return(-1);

		return(0);
	};
	
	/*!
		蓖
	*/
	static int SetToDeviceHANDLE(HANDLE hIocp, HANDLE hDevice, ULONG_PTR dwCompKey)
	{
		ASSERT(hIocp != NULL);
		HANDLE ret = CreateIoCompletionPort(hDevice, hIocp, dwCompKey, 0);
		if(ret != hIocp)
			return(-1);

		return(0);
	};

	/*!
		nh̎擾
	*/
	__inline operator HANDLE()
	{
		ASSERT(m_hIocp != NULL);
		return m_hIocp;
	};

protected:
	///////////////////////////////////////////////////////////////////
	//	o
	///////////////////////////////////////////////////////////////////
	//!	IOCP
	HANDLE	m_hIocp;
};
