#include "StdAfx.h"
#include "WorkspaceXMLReader.h"

#define	ATTR_KEY	0
#define	ATTR_DATA	1

CWorkspaceXMLReader::CWorkspaceXMLReader(void)
{
}

CWorkspaceXMLReader::~CWorkspaceXMLReader(void)
{
}

void CWorkspaceXMLReader::LoadFromFile(CWorkspaceNode *root, CUTF8String path, CUTF8String workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	//	
	StartScan(LoadXmlFile(path));

	//	ŏI`FbN
	if(m_depth.GetCount())
		throw CXMLTextParserException(_U16("SubnodeĂ܂"));
}

/*!
	XMLǂݍ(throw CXMLTextParserException)
*/
void CWorkspaceXMLReader::FromString(CWorkspaceNode *root, CUTF8String str, CUTF8String workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	//	
	StartScan(str);

	//	ŏI`FbN
	if(m_depth.GetCount())
		throw CXMLTextParserException(_U16("SubnodeĂ܂"));
}

/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CWorkspaceXMLReader::OnStartTag(LPCU8STR tag, LPCU8STR *atts, int attsCount)
{
	//	`FbN
	if(m_inKeyLeaf)
		throw CXMLTextParserException(_U16("KeyɃ^O͋Lqł܂"));

	//	^O
	if(MultiMatch(tag, "CWorkspaceClass", "CConfigClass"))		//	Jn
	{
		//	Jnʒu`FbN
		if(m_depth.GetCount() != 0)
			throw CXMLTextParserException(_U16("CWorkspaceClass^Oł"));

		//	^Cv`FbN
		if(attsCount != 2 || !MultiMatch(atts[ATTR_KEY], "type"))
			throw CXMLTextParserException(_U16("CWorkspaceClass^Oł"));

		//	NX`FbN
		if(m_workspaceClassType != atts[ATTR_DATA])
			throw CXMLTextParserException(_U16("[NXy[XقȂ܂A[hł܂"));
	}
	else if(MultiMatch(tag, "Subnode", "Node"))					//	m[h
	{
		//	^Cv`FbN
		if(attsCount != 2 || !MultiMatch(atts[ATTR_KEY], "name"))
			throw CXMLTextParserException(_U16("Subnode^Oł"));

		//	ŏʁH
		if(m_depth.GetCount() == 0)
		{
			//	NX`FbN
			if(m_workspaceClassType != atts[ATTR_DATA])
				throw CXMLTextParserException(_U16("[NXy[XقȂ܂A[hł܂"));
			else
				m_depth.AddTail(m_curNode);
		}
		else
		{
			//	ǉ
			m_curNode = m_curNode->GetSubNodeByName((LPCU8STR)atts[ATTR_DATA], TRUE); 
			if(m_curNode == NULL)
				throw CXMLTextParserException(_U16("Subnode݂܂"));
			m_depth.AddTail(m_curNode);
		}
	}
	else if(MultiMatch(tag, "Key", "Leaf"))						//	L[
	{
		//	`FbN
		if(m_depth.GetCount() == 0 || attsCount != 2 || !MultiMatch(atts[ATTR_KEY], "name", "key"))
			throw CXMLTextParserException(_U16("Key^Oł"));

		m_inKeyLeaf = 1;
		m_onDataCount = 0;
		m_keyName = atts[ATTR_DATA];
		m_keyData.Empty();
	}
	else	//	G[
	{
		throw CXMLTextParserException(_U16("ȃ^Oł"));
	}
}

/*!
	I^O
*/
void CWorkspaceXMLReader::OnEndTag(LPCU8STR tag)
{
	//	^O
	if(MultiMatch(tag, "CWorkspaceClass", "CConfigClass"))	//	Jn
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_U16("KeyɃ^O͋Lqł܂"));
	}
	else if(MultiMatch(tag, "Subnode", "Node"))						//	m[h
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_U16("KeyɃ^O͋Lqł܂"));

		//	m[h[`FbN
		if(m_depth.GetCount() <= 0)
			throw CXMLTextParserException(_U16("Subnode^ȎΉُł"));

		m_depth.RemoveTail();

		//	ŏʁH
		if(m_depth.GetCount() != 0)
			m_curNode = m_depth.GetTail();
		else
			m_curNode = NULL;
	}
	else if(MultiMatch(tag, "Key", "Leaf"))					//	L[
	{
		//	`FbN
		if(!m_inKeyLeaf)
			throw CXMLTextParserException(_U16("ȏI^Oł"));

		//	KvȂĐݒ
		if(m_onDataCount >= 2)
			m_curNode->SetKeyData(m_keyName, m_keyData, FALSE);
		m_onDataCount = 0;
		m_inKeyLeaf = 0;
	}
	else	//	G[
	{
		throw CXMLTextParserException(_U16("ȃ^Oł"));
	}
}

/*!
	f[^
*/
void CWorkspaceXMLReader::OnData(const utf8_char *data, int len)
{
	if(m_inKeyLeaf)
	{
		//	ēxĂяoH
		if(m_onDataCount == 0)
		{
			m_keyData.SetString(data, len);
			m_curNode->SetKeyData(m_keyName, m_keyData, FALSE);
		}
		else if(m_onDataCount == 1)
		{
			CUTF8String	strData;
			strData.SetString(data, len);

			m_keyData = m_curNode->GetKeyData(m_keyName, _U8(""), FALSE);
			m_keyData += strData;
		}
		else
		{
			CUTF8String	strData;
			strData.SetString(data, len);

			m_keyData += strData;
		}

		//	ĂяoJEg
		m_onDataCount++;
	}
}


/////////////////////////////////////////////////////////////////////////////////////
//	⏕
/////////////////////////////////////////////////////////////////////////////////////
/*!
	̕ or r
*/
int CWorkspaceXMLReader::MultiMatch(LPCU8STR tag, LPCSTR str1, LPCSTR str2, LPCSTR str3)
{
	//	r
	if(str1 != NULL && strcmp((LPCSTR)tag, str1) == 0)
		return(TRUE);

	//	r
	if(str2 != NULL && strcmp((LPCSTR)tag, str2) == 0)
		return(TRUE);

	//	r
	if(str3 != NULL && strcmp((LPCSTR)tag, str3) == 0)
		return(TRUE);

	return(FALSE);
}

