/*!
	eLXguNX
	{IɁAXML/HTML^O폜p
*/
#include "StdAfx.h"
#include "TextEscape.h"

///////////////////////////////////////////////////////////////////////////
//	GXP[vg[Nǉ
///////////////////////////////////////////////////////////////////////////
/*!
	ǉ
*/
void CTextEscape::AddEscape(CUTF8String token, CUTF8String escape)
{
	m_escape.Add(CTextEscapeItem(token, escape));
	m_unescape.Add(CTextEscapeItem(escape, token));
}

/*!
	NA
*/
void CTextEscape::Clear()
{
	m_escape.RemoveAll();
	m_unescape.RemoveAll();
}


///////////////////////////////////////////////////////////////////////////
//	̃GXP[v
///////////////////////////////////////////////////////////////////////////
/*!
	GXP[v̎s
*/
LPCU8STR CTextEscape::Escape(LPCU8STR src)
{
	return(Escape(src, m_escape));
}


/*!
	GXP[v̉
*/
LPCU8STR CTextEscape::UnEscape(LPCU8STR src)
{
	return(Escape(src, m_unescape));
}

/*!
	GXP[v̎s
*/
CUTF8String CTextEscape::Escape(CUTF8String src)
{
	return(Escape((LPCU8STR)src));
}

/*!
	GXP[v̉
*/
CUTF8String CTextEscape::UnEscape(CUTF8String src)
{
	return(UnEscape((LPCU8STR)src));
}


///////////////////////////////////////////////////////////////////////////
//	⏕
///////////////////////////////////////////////////////////////////////////
/*!
	GXP[v̎s
*/
LPCU8STR CTextEscape::Escape(LPCU8STR src, CSimpleArrayTemplate<CTextEscapeItem> &items)
{
	//	g|
	m_destBuf.SetNoFreeEmpty(TRUE);
	m_destBuf.Empty();

	while(1)
	{
		int	findIndex;
		int itemIndex = MultiFind(findIndex, src, items);

		if(itemIndex != -1)
		{
			//	؂o
			if(findIndex > 0)
				m_destBuf.Append((char*)src, findIndex);

			//	u
			m_destBuf.AppendString(items[itemIndex].m_escape);
			src += items[itemIndex].m_token.GetLength();
		}
		else
		{
			m_destBuf.AppendLPCU8STR(src);
			m_destBuf.AppendByte(0);
			return((LPCU8STR)m_destBuf.GetPtr());
		}
	}
}



/*!
	ԍŏɌCfbNX擾
*/
int CTextEscape::MultiFind(int &findIndex, LPCU8STR src, CSimpleArrayTemplate<CTextEscapeItem> &items)
{
	//	
	findIndex = 0;
	int	itemIndex = -1;

	//	SĂ݂
	for(int i=0;i<items.GetCount();i++)
	{
		int index = Find(src, items[i].m_token);
		if(index != -1)
		{
			//	擪ɋ߂H
			if(itemIndex == -1 || findIndex > index)
			{
				itemIndex = i;
				findIndex = index;
			}
		}
	}

	return(itemIndex);
}


/*!
	
*/
int CTextEscape::Find(LPCU8STR src, LPCU8STR find)
{
	//	
	LPCSTR ptr = strstr((LPCSTR)src, (LPCSTR)find);
	if(ptr == NULL)
		return(-1);

	return(ptr - (LPCSTR)src);
}

