#pragma once


/*!
	zNX⏕NX
*/
template< class _TYPE>
class CSimpleArrayTemplateItmeConstructor
{
protected:
	typedef	_TYPE		TYPE;

public:
	//!	RXgN^Ă
	static void ConstructItem(TYPE *item, void *userData)
	{
		//	}N`
		#pragma push_macro("new")
		#undef new

		//	v[Xg new ŗvf
		::new(item) TYPE;

		//	}N`߂
		#pragma pop_macro("new")
	};

	//!	fXgN^Ă
	static void DestructItem(TYPE *item, void *userData)
	{
		item->~TYPE();
	};
};


/*!
	Ǝ̔zNX

	RXgN^Ɉ邽߂ƁAv[𗘗p邽߂ɁAƎ
	{IɁApĎg
*/
template< class _TYPE, class _ARG_TYPE = _TYPE&, class _CONSTRUCTOR = CSimpleArrayTemplateItmeConstructor<_TYPE>, int INIT_ALLOC = 5>
class CSimpleArrayTemplate
{
protected:
	//	qNXŎgpł悤
	typedef	_TYPE			TYPE;
	typedef	_ARG_TYPE		ARG_TYPE;
	typedef	_CONSTRUCTOR	CONSTRUCTOR;

public:
	CSimpleArrayTemplate()
	{
		InitInternal();
	}

	virtual ~CSimpleArrayTemplate(void)
	{
		Close();
	}

	//////////////////////////////////////////////////////////////
	//	ǉ
	//////////////////////////////////////////////////////////////
	//!	ǉ
	virtual void Add(ARG_TYPE item)
	{
		//	
		Grow(1);

		//	RXgN^Ă
		CallConstructors(m_items + GetCount(), 1);

		//	Rs[
		CopyItems(m_items + GetCount(), &item, 1);

		//	
		m_usedSize++;
	}

	//!	܂Ƃ߂Ēǉ
	virtual void Append(const CSimpleArrayTemplate<TYPE, ARG_TYPE, CONSTRUCTOR, INIT_ALLOC> &other)
	{
		//	擾
		int	count = other.GetCount();

		//	
		Grow(count);

		//	RXgN^Ă
		CallConstructors(m_items + GetCount(), count);

		//	Rs[
		CopyItems(m_items + GetCount(), other.m_items, count);

		//	
		m_usedSize += count;
	}

	//////////////////////////////////////////////////////////////
	//	폜
	//////////////////////////////////////////////////////////////
	//!	폜
	virtual void RemoveAt(int index)
	{
		ASSERT(index >= 0 && index < GetCount());

		//	fXgN^Ă
		CallDestructors(m_items + index, 1);

		//	ړ
		MoveItems(m_items + index, m_items + (index + 1), GetCount() - index - 1);

		//	
		m_usedSize--;
	}

	//!	ׂč폜
	virtual void RemoveAll()
	{
		SetSize(0);
	}

	//!	]vȃ̉
	virtual void FreeExtra()
	{
		Alloc(GetCount());
	}

	//////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////
	//!	擾
	virtual ARG_TYPE GetAt(int index)
	{
		ASSERT(index >= 0 && index < GetCount());

		return(m_items[index]);
	}

	//!	擾
	virtual ARG_TYPE operator[](int index)
	{
		return GetAt(index);
	}

	//////////////////////////////////////////////////////////////
	//	̑̑
	//////////////////////////////////////////////////////////////
	//!	Rs[
	virtual void Copy(const CSimpleArrayTemplate<TYPE, ARG_TYPE, CONSTRUCTOR, INIT_ALLOC> &other)
	{
		//	擾
		int	count = other.GetCount();

		//	TCYύX
		SetSize(count);

		//	Rs[
		CopyItems(m_items, other.m_items, count);
	}

	//!	TCYύX
	virtual void SetSize(int size)
	{
		ASSERT(size >= 0);

		if(size > GetCount())
		{
			//	TCY
			Grow(size - GetCount());

			//	RXgN^Ă
			CallConstructors(m_items + GetCount(), size - GetCount());

			//	TCYύX
			m_usedSize = size;
		}
		else if(size < GetCount())
		{
			//	fXgN^Ă
			CallDestructors(m_items + size, GetCount() - size);

			//	TCYύX
			m_usedSize = size;
		}
	}

	//////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////
	//!	TCY擾
	virtual int GetCount() const
	{
		return m_usedSize;
	}


protected:
	//////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////
	//!	ϐ
	virtual void InitInternal()
	{
		m_mainBuf = NULL;
		m_items = NULL;
		m_usedSize = 0;
		m_bufSize = 0;

		m_constructorsUserData = NULL;
	}

	//!	m
	virtual void Grow(int wantSize)
	{
		//	̕Kv͂邩H
		if(m_bufSize - m_usedSize >= wantSize)
			return;

		//	VTCYvZ
		Alloc(CalcGrowSize(m_bufSize, wantSize));
	}

	//!	Ċm
	virtual void Alloc(int size)
	{
		ASSERT(size >= GetCount());

		//	̕Kv͂邩H
		if(m_bufSize == size)
			return;

		//	폜H
		if(size == 0)
		{
			Close();
			return;
		}

		//	Vobt@m
		BYTE *newBuf = (BYTE*)AllocMemoryBlock(sizeof(TYPE), size);
		TYPE *newItems = (TYPE*)newBuf;

		//	NAĂ
		memset(newBuf, 0, size * sizeof(TYPE));

		//	ړ
		if(m_mainBuf != NULL)
		{
			MoveItems(newItems, m_items, GetCount());
			FreeMemoryBlock(m_mainBuf);
		}

		//	ϐ
		m_mainBuf = newBuf;
		m_items = newItems;
		m_bufSize = size;
	}

	//!	Sf[^
	virtual void Close()
	{
		if(m_mainBuf)
		{
			//	fXgN^ׂČĂ
			CallDestructors(m_items, GetCount());

			//	
			FreeMemoryBlock(m_mainBuf);
		}
		InitInternal();
	}

	//////////////////////////////////////////////////////////////
	//	I[o[[hp
	//////////////////////////////////////////////////////////////
	//!	RXgN^Ă
	virtual void CallConstructors(TYPE* items, int count)
	{
		//	Svf
		for( int i=0; i<count; i++ )
			CONSTRUCTOR::ConstructItem(items + i, m_constructorsUserData);

	}

	//!	fXgN^Ă
	virtual void CallDestructors(TYPE* items, int count)
	{
		//	fXgN^Ăяo
		for( int i=0; i<count; i++ )
			CONSTRUCTOR::DestructItem(items + i, m_constructorsUserData);
	}

	//!	ړ
	virtual void MoveItems(TYPE *to, const TYPE *from, int count)
	{
		//	ubNړ
		memmove(to, from, count * sizeof(TYPE));
	}

	//!	Rs[
	virtual void CopyItems(TYPE *to, const TYPE *from, int count)
	{
		//	= ŃRs[
		for( int i=0; i<count; i++ )
			to[i] = from[i];
	}

	//!	mۃTCY̌vZ(ŕԂ)
	virtual int CalcGrowSize(int curSize, int wantSize)
	{
		//	l
		if(curSize == 0 && wantSize < INIT_ALLOC)
			return INIT_ALLOC;

		//	Wł́A2{ɂȂĂ
		if(wantSize < curSize)
			return curSize * 2;
		else
			return curSize + wantSize;
	}

	//!	RXgN^p[Uf[^ݒ
	void SetConstructorsUserData(void *constructorsUserData)
	{
		m_constructorsUserData = constructorsUserData;
	}

	//!	ubNm
	virtual void *AllocMemoryBlock(int blockSize, int count)
	{
		return new BYTE[blockSize * count];
	}

	//!	ubNJ
	virtual void FreeMemoryBlock(void *memPtr)
	{
		delete (BYTE*)memPtr;
	}

	//////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////
	//!	Cobt@
	BYTE	*m_mainBuf;

	//!	擪|C^
	TYPE	*m_items;

	//!	݊mے̃TCY
	int		m_bufSize;

	//!	ݎgp̃TCY
	int		m_usedSize;

	//!	[U[f[^
	void	*m_constructorsUserData;
};


