#pragma once
#include "BinaryData.h"
#include "PipePair.h"
#include "Workspace.h"


/*!
	TuvZX
*/
class CSubProcess
{
public:
	CSubProcess(void);
	virtual ~CSubProcess(void);

	///////////////////////////////////////////////////////////////////////
	//	TuvZXNA
	///////////////////////////////////////////////////////////////////////
	//!	TuvZX̋N
	virtual int RunSubProcess(CString command, CString workPath, CString idString);

	//!	vZX͎sH
	virtual int SubProcessIsRunning();

	//!	I
	virtual void TerminateSubProcess();

	///////////////////////////////////////////////////////////////////////
	//	ʐM
	///////////////////////////////////////////////////////////////////////
	//!	STDIN֏o
	virtual int WriteStdIn(CBinaryData &buf, HANDLE breakEvent, int timeout) { return m_stdIn.Write(buf, breakEvent, timeout); };

	//!	STDOUTǂݏo
	virtual int ReadStdOut(CBinaryData &buf, int blockSize, HANDLE breakEvent, int timeout) { return m_stdOut.Read(buf, blockSize, breakEvent, timeout); };

	//!	STDOUTǂݏo(j)
	virtual int PeekStdOut(CBinaryData &buf, int blockSize) { return m_stdOut.Peek(buf, blockSize); };

	//!	STDERRǂݏo
	virtual int ReadStdErr(CBinaryData &buf, int blockSize, HANDLE breakEvent, int timeout)  { return m_stdErr.Read(buf, blockSize, breakEvent, timeout); };

	//!	STDOUTǂݏo(j)
	virtual int PeekStdErr(CBinaryData &buf, int blockSize)  { return m_stdErr.Peek(buf, blockSize); };

	///////////////////////////////////////////////////////////////////////
	//	ϐ
	///////////////////////////////////////////////////////////////////////
	//!	ϐ̒ǉ
	void AddSubProcessEnvironment(CString env);

	//!	ϐ̒ǉ
	void AddSubProcessEnvironmentWorkspace(CWorkspaceAccess workspace);

	//!	NA
	void ClearSubProcessEnvironment();

protected:
	///////////////////////////////////////////////////////////////////////
	//	⏕֐
	///////////////////////////////////////////////////////////////////////
	//!	pCv
	int SetupPipe(CString idString);

	///////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////
	//!	StdIn
	CPipePair			m_stdIn;

	//!	StdOut
	CPipePair			m_stdOut;

	//!	StdErr
	CPipePair			m_stdErr;

	//!	vZX
	PROCESS_INFORMATION m_processInfo;

	//!	ϐ
	CBinaryData			m_subProcessEnvironment;

	//!	NtO
	int					m_processCreated;
};
