#pragma once
#include "types/BinaryDataTypes.h"
#include "UTF8String.h"
#include "UTF8StringConvert.h"


/*!
	oCif[^ۉNX

	char[]`̃oCif[^Ǘ
	TCYŒ
*/
class CBinaryData
{
public:
	CBinaryData(int allocSize = 0);
	CBinaryData(CBinaryData &other);
	CBinaryData(IBinaryDataPtr other);
	virtual ~CBinaryData(void);

	////////////////////////////////////////////////////////////////////////////////////////
	//	C^tF[XȂ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	IBinaryDataPtr GetCoreInterface() { return m_interface; };

	//!	C^[tF[Xݒ
	void SetCoreInterface(IBinaryDataPtr interfaceToSet) { m_interface = interfaceToSet; };

	////////////////////////////////////////////////////////////////////////////////////////
	//	m
	////////////////////////////////////////////////////////////////////////////////////////
	//!	̈TCYύX
	void ReSize(int size) { m_interface->ReSize(size); }

	//! TCY擾
	int GetSize() {	return m_interface->GetSize(); };

	//! ʂݒ
	void SetGrowSize(int size) { m_core.SetGrowSize(size); };

	//! 0TCYɃȂî߁j
	void SetNoFreeEmpty(int size) { m_core.SetNoFreeEmpty(size); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	폜
	////////////////////////////////////////////////////////////////////////////////////////
	//! 폜
	int Remove(int start, int size);

	//! ɂ
	void Empty() { ReSize(0); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	|C^ANZX
	////////////////////////////////////////////////////////////////////////////////////////
	//!	擪|C^擾
	char * GetPtr() { return m_interface->GetPtr(); };

	//! char* ɕϊ
	operator char*() { return GetPtr(); };

	//! unsigned char* ɕϊ
	operator unsigned char*()  { return (unsigned char *)GetPtr(); };

	//! CUTF8String ɕϊ
	operator CUTF8String() { return GetString(); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////////
	//!	㏑(KvȂ΁Aobt@ǉ)
	void OverwriteData(int startOffset, char *data, int len);

	//!	ǉ
	void Append(char *data,int size);

	//!	ǉ
	void AppendLPCU8STR(LPCU8STR str)		{ Append((char *)str, strlen((char *)str)); };

	//!	ǉ
	void AppendLPCSTR(LPCSTR str)			{ AppendLPCU8STR(_cnvU8(str)); };

	//!	ǉ(CUTF8String)
	void AppendString(CUTF8String &str)		{ AppendLPCU8STR(str); };

	//!	ǉ(CBinaryData)
	void AppendBinary(CBinaryData &data)	{ Append(data.GetPtr(), data.GetSize()); };

	//!	ǉ(char)
	void AppendByte(char val)				{ Append(&val, 1); };

	//!	ǉ(short)
	void AppendWord(short val)				{ Append((char *)&val, 2); };

	//!	ǉ(long)
	void AppendDoubleWord(long val)			{ Append((char *)&val, 4); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	CUTF8String
	CUTF8String GetString();

	////////////////////////////////////////////////////////////////////////////////////////
	//	T[`
	////////////////////////////////////////////////////////////////////////////////////////
	//!	̈̌
	int SerachMemBlock(const char *block, int blockLen);

	//!	̈̌
	int SerachString(const CUTF8String &str)	{ return SerachMemBlock((const char *)str.GetString(), str.GetLength()); }

	////////////////////////////////////////////////////////////////////////////////////////
	//	t@C
	////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^ۑ
	int SaveToFile(CUTF8String path);

	//!	Sēǂݍ
	int LoadFromFile(CUTF8String path);

protected:
	class CBinaryDataCore : public IBinaryData
	{
	public:
		CBinaryDataCore();
		virtual ~CBinaryDataCore();

		//!	TCYύX
		virtual void ReSize(int size);

		//!	TCY擾
		virtual int GetSize();

		//!	ێĂf[^|C^擾
		virtual char *GetPtr();

		////////////////////////////////////////////////////////////////////////////////////////
		//	
		////////////////////////////////////////////////////////////////////////////////////////
		//!	
		void InitInternal();

		//! ʂݒ
		void SetGrowSize(int size) { m_growSize = size; };

		//!	0TCYɃȂî߁j
		void SetNoFreeEmpty(int enable) { m_noFreeEmpty = enable; };

	protected:
		////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		////////////////////////////////////////////////////////////////////////////////////////
		//!	obt@{
		char	*m_buffer;

		//! obt@TCY
		int		m_usingSize;

		//! mۍς݃obt@TCY
		int		m_bufferSize;

		//! TCY
		int		m_growSize;

		//!	0TCỸ
		int		m_noFreeEmpty;
	};

	////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	obt@{
	CBinaryDataCore	m_core;

	//!	obt@ANZX
	IBinaryDataPtr	m_interface;
};

