#pragma once

//	錾Ă
template<typename TYPE, typename DEL_METHOD = CInterfaceAutoPtrDefaultDelete<TYPE>>
class CInterfaceAutoPtrTempCopy;

/*!
	W폜\bh
*/
template<typename TYPE>
class CInterfaceAutoPtrDefaultDelete
{
public:
	/*!
		폜\bh
	*/
	static void Delete(TYPE *toDelete)
	{
		toDelete->Delete();
	};
};


/*!
	|C^bp

	}`Xbh̃ANZXs
*/
template<typename TYPE, typename DEL_METHOD = CInterfaceAutoPtrDefaultDelete<TYPE>>
class CInterfaceAutoPtr
{
	friend class CInterfaceAutoPtrTempCopy<TYPE, DEL_METHOD>;

public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	錾p
	CInterfaceAutoPtr()
	{
		m_ifPtr = NULL;
		m_refCounter = 0;
	};

	//!	A^b`
	CInterfaceAutoPtr(TYPE *ifPtr)
	{
		m_ifPtr = NULL;
		m_refCounter = 0;

		//	A^b`
		Attach(ifPtr);
	};

	//!	I
	virtual ~CInterfaceAutoPtr()
	{
		Delete();
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	蓖
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	A^b`
	void Attach(TYPE *ifPtr)
	{
		Delete();
		m_ifPtr = ifPtr;
	};

	//!	J(폜͂Ȃ)
	TYPE *Detach()
	{
		ASSERT(CheckNoRef());

		TYPE *ret = m_ifPtr;
		m_ifPtr = NULL;
		return ret;
	};

	//!	I
	void Delete()
	{
		ASSERT(CheckNoRef());

		//	폜
		if(m_ifPtr)
			DEL_METHOD::Delete(m_ifPtr);
		m_ifPtr = NULL;
	};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[iRs[EmptyɂȂj
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CInterfaceAutoPtr(CInterfaceAutoPtr &other)
	{
		m_ifPtr = other.m_ifPtr;
		other.Detach();
	};

	//!	Rs[
	void operator=(const CInterfaceAutoPtr &other)
	{
		Delete();

		m_ifPtr = other.m_ifPtr;
		const_cast<CInterfaceAutoPtr&>(other).Detach();
	};

	//!	r
	int operator==(const CInterfaceAutoPtr &other)
	{
		return(m_ifPtr == other.m_ifPtr);
	};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ifPtr != NULL);

		return m_ifPtr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ifPtr != NULL);

		return *m_ifPtr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ifPtr == NULL);
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	t@XJEg(CInterfaceAutoPtrTempCopyR[)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	m
	void IncrementRef()
	{
		ASSERT(::InterlockedIncrement(&m_refCounter) == 0);
	}

	//!	J
	void DecrementRef()
	{
		ASSERT(::InterlockedDecrement(&m_refCounter) != 0xFFFFFFFF);
	}

	//!	0H
	int CheckNoRef()
	{
		if(::InterlockedExchangeAdd(&m_refCounter, 0) == 0)
			return(TRUE);
		return(FALSE);
	}


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	TYPE	*m_ifPtr;

	//!	pJE^
	LONG	m_refCounter;
};



/*!
	|C^bp ꎟp
*/
template<typename TYPE, typename DEL_METHOD>
class CInterfaceAutoPtrTempCopy
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	錾
	CInterfaceAutoPtrTempCopy()
	{
		m_ifPtr = NULL;
		m_source = NULL;
	};

	//!	J
	virtual ~CInterfaceAutoPtrTempCopy()
	{
		Detach();
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	蓖
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	A^b`
	void Attach(CInterfaceAutoPtr<TYPE, DEL_METHOD> &source)
	{
		ASSERT(source != NULL);
		Detach();

		//	擾
		m_source = &source;
		m_ifPtr = source->m_ifPtr;
		source->IncrementRef();
	};

	//!	J(폜͂Ȃ)
	void Detach()
	{
		//	J
		if(m_source)
			m_source->DecrementRef();

		m_ifPtr = NULL;
		m_source = NULL;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CInterfaceAutoPtrTempCopy(CInterfaceAutoPtr<TYPE, DEL_METHOD> &source)
	{
		m_ifPtr = NULL;
		m_source = NULL;

		Attach(source);
	};

	//!	Rs[RXgN^
	CInterfaceAutoPtrTempCopy(CInterfaceAutoPtrTempCopy &other)
	{
		Attach(other.m_source);
	};

	//!	Rs[
	void operator=(const CInterfaceAutoPtr<TYPE, DEL_METHOD> &other)
	{
		Attach(&other);
	};

	//!	Rs[
	void operator=(const CInterfaceAutoPtrTempCopy &other)
	{
		Attach(other.m_source);
	};

	//!	r
	int operator==(const CInterfaceAutoPtr<TYPE, DEL_METHOD> &other)
	{
		return(m_source == &other);
	};

	//!	r
	int operator==(const CInterfaceAutoPtrTempCopy &other)
	{
		return(m_source == other.m_source);
	};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ifPtr != NULL);

		return m_ifPtr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ifPtr != NULL);

		return *m_ifPtr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ifPtr == NULL);
	};


protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	TYPE				*m_ifPtr;

	//!	Rs[
	CInterfaceAutoPtr<TYPE, DEL_METHOD>	*m_source;
};
