#include "StdAfx.h"
#include "WorkspaceNode.h"


//////////////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////////////
CWorkspaceNode::CWorkspaceNode()
{
}

CWorkspaceNode::CWorkspaceNode(LPCU8STR name)
{
	SetNodeName(name);
}

CWorkspaceNode::CWorkspaceNode(const CWorkspaceNode &other)
{
	SetNodeName(other.GetNodeName());
	m_keyData.Copy(other.m_keyData);
	m_subNode.Copy(other.m_subNode);
}


CWorkspaceNode::~CWorkspaceNode(void)
{
}

//	Rs[Iy[^
void CWorkspaceNode::operator=(const CWorkspaceNode &other)
{
	//	f[^̃Rs[
	SetNodeName(other.GetNodeName());
	m_keyData.Copy(other.m_keyData);
	m_subNode.Copy(other.m_subNode);
}

//	SăNA
void CWorkspaceNode::Clear(void)
{
	//	f[^폜
	m_keyData.RemoveAll();
	m_subNode.RemoveAll();
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	f[^̐ݒ

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::SetKeyData(LPCU8STR key, LPCU8STR data, int noCase)
{
	m_keyData.Add(key, data,  noCase);
}

/*!
	f[^̎擾

	̃m[h̃f[^ɑ΂ANZX
*/
LPCU8STR CWorkspaceNode::GetKeyData(LPCU8STR key, LPCU8STR defaultData, int noCase)
{
	return m_keyData.Get(key, defaultData,  noCase);
}


/*!
	f[^̍폜

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::DeleteKey(LPCU8STR key)
{
	m_keyData.Delete(key);
}


/*!
	L[擾
*/
int CWorkspaceNode::GetKeyCount()
{
	return((int)m_keyData.GetCount());
}

/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceNode::GetAllKeyPair(IStringArrayPtr keys, IStringArrayPtr datas)
{
	//	TCY
	int count = (int)m_keyData.GetCount();
	if(keys != NULL)
		keys->SetSize(count);
	if(datas != NULL)
		datas->SetSize(count);

	//	ݒ
	for(int i=0;i<count;i++)
	{
		CWorkspaceKeyPair	*keyPair = m_keyData.GetByIndex(i);

		//	NULLłȂΐݒ
		if(keys != NULL)
			keys->SetString(i, keyPair->GetKey());
		if(datas != NULL)
			datas->SetString(i, keyPair->GetData());
	}

	return(count);
}


/*!
	L[܂Ƃ߂Đݒ
*/
void CWorkspaceNode::ClearAndSetKeys(CUTF8StringArray &keys, CUTF8StringArray &datas)
{
	//	S폜
	m_keyData.RemoveAll();

	//	ݒ
	for(int i=0;i<keys.GetCount();i++)
		m_keyData.AddNoCompare(keys[i], datas[i]);
}

//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Protect)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Leaf̌
*/
int CWorkspaceNode::FindKeyIndex(LPCU8STR key,int noCase)
{
	return(m_keyData.Find(key, noCase));
}

//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
CWorkspaceNode *CWorkspaceNode::GetSubNode(CWorkspaceNodeWalker &path, CUTF8String &key)
{
	//	ŌH
	if(path.CurrentIsLastNode())
	{
		//	̃L[
		key = path.GetCurrentNode();
		return this;
	}
	else
	{
		//	̃Tum[h
		CWorkspaceNode *subNode = GetSubNodeByName(path.GetCurrentNode());

		//	ɉ
		path.WalkToNextNode();
		return(subNode->GetSubNode(path, key));
	}
}


/*!
	m[h폜

*/
void CWorkspaceNode::DeleteNode(LPCU8STR name)
{
	int index = FindSubNodeIndex(name);
	if(index != -1)
		m_subNode.RemoveAt(index);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceNode::GetSubNodeCount()
{
	return((int)m_subNode.GetCount ());
}


/*!
	SẴTum[h𕶎ƂĎ擾

	̃Tum[ĥ݂łB
	ʃm[hւ͌ɍs܂
*/
int CWorkspaceNode::GetAllSubNode(IStringArrayPtr list)
{
	//	TCY
	int count = (int)m_subNode.GetCount ();
	list->SetSize(count);

	//	ݒ
	for(int i=0;i<count;i++)
		list->SetString(i, m_subNode[i].GetNodeName());

	return(count);
}



//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Protected)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
int CWorkspaceNode::FindSubNodeIndex(LPCU8STR name)
{
	for(int i=0;i<(int)m_subNode.GetCount();i++)
	{
		if(strcmp((LPCSTR)m_subNode[i].GetNodeName(), (LPCSTR)name) == 0)
			return(i);
	}
	return -1;
}


/***********************************************************************************
	o͂Ɋւ鏈
***********************************************************************************/
/*!
	Tum[h𖼑O擾E쐬

	\param errorIfExist	TRUEƁAɑ݂ĂꍇɃG[ƂȂ
*/
CWorkspaceNode *CWorkspaceNode::GetSubNodeByName(LPCU8STR name, int errorIfExist)
{
	int	index = FindSubNodeIndex(name);
	if(index == -1)
	{
		//	ǉ
		m_subNode.Add(CWorkspaceNode(name));
		return &m_subNode[m_subNode.GetCount ()-1];
	}

	//	G[H
	if(errorIfExist)
		return(NULL);
	return(&m_subNode[index]);
}


/*!
	Tum[hCfbNXŎ擾
*/
CWorkspaceNode *CWorkspaceNode::GetSubNodeByIndex(int index)
{
	if(index < 0 || index >= (int)m_subNode.GetCount())
		return(NULL);

	return(&m_subNode[index]);
}

/*!
	L[CfbNXŎ擾
*/
CWorkspaceKeyPair *CWorkspaceNode::GetKeyByIndex(int index)
{
	if(index < 0 || index >= m_keyData.GetCount())
		return(NULL);

	return(m_keyData.GetByIndex(index));
}

